/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.accessmanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.accessmanager.AccessControlUtil;

public class DeleteAcesServlet
extends HttpServlet {
    public static final String ABS_PATH = "absPath";
    public static final String APPLY_TO = "applyTo";
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String absPath;
        boolean modified;
        PrintWriter out;
        block11: {
            System.out.println("Servlet Delete Aces called ......");
            response.setContentType("text/plain");
            out = response.getWriter();
            Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
            SessionImpl session = null;
            XStream xstream = null;
            String xmlConfig = null;
            modified = false;
            absPath = null;
            String[] applyTo = null;
            try {
                xstream = new XStream();
                session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
                absPath = request.getParameter(ABS_PATH);
                applyTo = request.getParameterValues(APPLY_TO);
                modified = this.deleteAces(session, absPath, applyTo);
                xmlConfig = xstream.toXML((Object)modified);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                if (session == null) break block11;
            }
            catch (RepositoryException e) {
                block12: {
                    try {
                        xmlConfig = xstream.toXML((Object)modified);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        if (session == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            session.logout();
                        }
                        out.close();
                        out.flush();
                        if (modified) {
                            System.out.println("removed privilege to node " + absPath);
                        } else {
                            System.out.println("cannot remove privilege to node " + absPath);
                        }
                        throw throwable;
                    }
                    session.logout();
                }
                out.close();
                out.flush();
                if (modified) {
                    System.out.println("removed privilege to node " + absPath);
                } else {
                    System.out.println("cannot remove privilege to node " + absPath);
                }
            }
            session.logout();
        }
        out.close();
        out.flush();
        if (modified) {
            System.out.println("removed privilege to node " + absPath);
        } else {
            System.out.println("cannot remove privilege to node " + absPath);
        }
    }

    private boolean deleteAces(SessionImpl jcrSession, String resourcePath, String[] principalNamesToDelete) throws RepositoryException {
        if (principalNamesToDelete == null) {
            return false;
        }
        if (jcrSession == null) {
            return false;
        }
        if (resourcePath == null) {
            return false;
        }
        Item item = jcrSession.getItem(resourcePath);
        if (item == null) {
            return false;
        }
        resourcePath = item.getPath();
        HashSet<String> pidSet = new HashSet<String>();
        pidSet.addAll(Arrays.asList(principalNamesToDelete));
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)jcrSession);
            AccessControlList updatedAcl = this.getAccessControlList(accessControlManager, resourcePath, false);
            AccessControlEntry[] accessControlEntries = updatedAcl.getAccessControlEntries();
            ArrayList<AccessControlEntry> oldAces = new ArrayList<AccessControlEntry>();
            for (AccessControlEntry ace : accessControlEntries) {
                if (!pidSet.contains(ace.getPrincipal().getName())) continue;
                oldAces.add(ace);
            }
            if (!oldAces.isEmpty()) {
                for (AccessControlEntry ace : oldAces) {
                    updatedAcl.removeAccessControlEntry(ace);
                }
            }
            accessControlManager.setPolicy(resourcePath, (AccessControlPolicy)updatedAcl);
            jcrSession.save();
        }
        catch (RepositoryException re) {
            re.printStackTrace();
            return false;
        }
        return true;
    }

    protected AccessControlList getAccessControlList(AccessControlManager accessControlManager, String resourcePath, boolean mayCreate) throws RepositoryException {
        AccessControlPolicy[] policies;
        for (AccessControlPolicy policy : policies = accessControlManager.getPolicies(resourcePath)) {
            if (!(policy instanceof AccessControlList)) continue;
            return (AccessControlList)policy;
        }
        if (mayCreate) {
            AccessControlPolicyIterator applicablePolicies = accessControlManager.getApplicablePolicies(resourcePath);
            while (applicablePolicies.hasNext()) {
                AccessControlPolicy policy = applicablePolicies.nextAccessControlPolicy();
                if (!(policy instanceof AccessControlList)) continue;
                return (AccessControlList)policy;
            }
        }
        throw new RepositoryException("Unable to find or create an access control policy to update for " + resourcePath);
    }
}

