/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;

public class GetVersionServlet
extends HttpServlet {
    public static final String VERSION_LABEL = "hl:version";
    public static final String USER = "user";
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("Servlet GetDisplayNameServlet called ......");
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        String version = null;
        XStream xstream = null;
        String xmlConfig = null;
        try {
            xstream = new XStream();
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
            String login = request.getParameter(USER);
            UserManager userManager = session.getUserManager();
            Authorizable authorizable = userManager.getAuthorizable(login);
            if (authorizable.isGroup()) {
                Group group = (Group)authorizable;
                Value[] versionValue = group.getProperty(VERSION_LABEL);
                version = this.getVersion(versionValue);
            } else {
                User user = (User)authorizable;
                Value[] versionValue = user.getProperty(VERSION_LABEL);
                version = this.getVersion(versionValue);
            }
            System.out.println("version: " + version);
            xmlConfig = xstream.toXML((Object)version);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            xmlConfig = xstream.toXML(version);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }

    private String getVersion(Value[] versionValue) throws ValueFormatException, IllegalStateException, RepositoryException {
        String version = null;
        int size = versionValue.length;
        for (int i = 0; i < size; ++i) {
            version = versionValue[i].getString();
        }
        return version;
    }
}

