/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;

public class GroupMembershipServlet
extends HttpServlet {
    public static final String GROUP_NAME = "groupName";
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("Servlet FetchGroupMembersServlet called ......");
        String message = "";
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        try {
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
            String groupName = request.getParameter(GROUP_NAME);
            ArrayList<String> members = new ArrayList<String>();
            UserManager userManager = session.getUserManager();
            Authorizable authorizable = userManager.getAuthorizable(groupName);
            if (authorizable.isGroup()) {
                Group group = (Group)authorizable;
                Iterator iter = group.getMembers();
                while (iter.hasNext()) {
                    Authorizable auth = (Authorizable)iter.next();
                    if (auth.isGroup()) continue;
                    members.add(auth.getID());
                }
            }
            XStream xstream = new XStream();
            String xmlConfig = xstream.toXML(members);
            out.println(xmlConfig);
        }
        catch (RepositoryException e) {
            message = e.getMessage();
            response.setContentLength(message.length());
            out.println(message);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }
}

