/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;

public class ListUsersServlet
extends HttpServlet {
    public static final String USER_NAME = "userName";
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("Servlet ListUsersServlet called ......");
        ArrayList<String> users = null;
        String message = "";
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        try {
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
            UserManager userManager = session.getUserManager();
            System.out.println("userManager");
            users = new ArrayList<String>();
            Iterator iter = userManager.findAuthorizables("jcr:primaryType", "rep:User");
            while (iter.hasNext()) {
                Authorizable auth = (Authorizable)iter.next();
                if (auth.isGroup()) continue;
                users.add(auth.getID());
            }
            if (!userManager.isAutoSave()) {
                session.save();
            }
            XStream xstream = new XStream();
            String xmlConfig = xstream.toXML(users);
            out.println(xmlConfig);
        }
        catch (RepositoryException e) {
            message = e.getMessage();
            response.setContentLength(message.length());
            out.println(message);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }
}

