/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;

public class SetVersionServlet
extends HttpServlet {
    public static final String USER = "user";
    public static final String VERSION = "version";
    public static final String VERSION_LABEL = "hl:version";
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("Servlet SetVersionServlet called ......");
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        boolean modified = false;
        XStream xstream = null;
        String xmlConfig = null;
        try {
            xstream = new XStream();
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
            String groupName = request.getParameter(USER);
            String version = request.getParameter(VERSION);
            Value VersioneValue = this.getValue(session, version);
            UserManager userManager = session.getUserManager();
            Authorizable authorizable = userManager.getAuthorizable(groupName);
            if (authorizable.isGroup()) {
                Group group = (Group)authorizable;
                group.setProperty(VERSION_LABEL, VersioneValue);
                System.out.println("setting hl:version : " + VersioneValue.getString());
                session.save();
            } else {
                User user = (User)authorizable;
                user.setProperty(VERSION_LABEL, VersioneValue);
                System.out.println("setting hl:version : " + VersioneValue.getString());
                session.save();
            }
            modified = true;
            xmlConfig = xstream.toXML((Object)modified);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (RepositoryException e) {
            modified = false;
            xmlConfig = xstream.toXML((Object)modified);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }

    private Value getValue(SessionImpl session, String value) throws RepositoryException {
        return session.getValueFactory().createValue(value);
    }
}

