/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibrary.model.exceptions.InternalErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDelegateWrapper {
    protected static final String ACCOUNTING = "hl:accounting";
    protected static final String NT_ACCOUNTING = "nthl:accountingSet";
    private static Logger logger = LoggerFactory.getLogger(ItemDelegateWrapper.class);
    String login;
    ItemDelegate item;
    XStream xstream;

    public ItemDelegateWrapper(ItemDelegate item, String login) throws Exception {
        this.item = item;
        this.login = login;
        this.xstream = new XStream();
    }

    public ItemDelegate addNode(Session session) throws Exception {
        Node parentNode = session.getNodeByIdentifier(this.item.getParentId());
        logger.info("add node to parentNode " + parentNode.getPath() + " - item: " + this.item.toString());
        String type = this.item.getPrimaryType();
        logger.info(this.item.getPath() + " type: " + type);
        Node node = null;
        try {
            logger.info("Adding " + this.item.getName() + " - type: " + type);
            node = parentNode.addNode(Text.escapeIllegalJcrChars((String)this.item.getName()), type);
            this.item.setPath(node.getPath());
            this.item.setId(node.getIdentifier());
        }
        catch (Exception e) {
            logger.error("Error adding a new node to " + parentNode.getPath(), (Throwable)e);
        }
        this.setProperties(node);
        this.setCustomProperties(node, this.item);
        logger.info("Saving item " + this.item.getPath());
        session.save();
        return this.getItemDelegate(node, this.login);
    }

    private void setProperties(Node node) throws RepositoryException {
        try {
            if (node.hasProperty(NodeProperty.TITLE.toString())) {
                logger.info("update TITLE from: " + node.getProperty(NodeProperty.TITLE.toString()).getString() + " to " + this.item.getTitle());
            } else {
                logger.info("setting TITLE to: " + this.item.getTitle());
            }
            node.setProperty(NodeProperty.TITLE.toString(), Text.escapeIllegalJcrChars((String)this.item.getTitle()));
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.TITLE);
        }
        try {
            if (node.hasProperty(NodeProperty.PORTAL_LOGIN.toString())) {
                logger.info("update PORTAL_LOGIN from: " + node.getProperty(NodeProperty.PORTAL_LOGIN.toString()).getString() + " to " + this.item.getOwner());
            } else {
                logger.info("setting PORTAL_LOGIN to: " + this.item.getOwner());
            }
            node.setProperty(NodeProperty.PORTAL_LOGIN.toString(), this.item.getOwner());
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.PORTAL_LOGIN);
        }
        try {
            if (node.hasProperty(NodeProperty.DESCRIPTION.toString())) {
                logger.info("update DESCRIPTION from: " + node.getProperty(NodeProperty.DESCRIPTION.toString()).getString() + " to " + this.item.getDescription());
            } else {
                logger.info("setting DESCRIPTION to: " + this.item.getDescription());
            }
            node.setProperty(NodeProperty.DESCRIPTION.toString(), Text.escapeIllegalJcrChars((String)this.item.getDescription()));
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.DESCRIPTION);
        }
        try {
            if (!this.item.getLastAction().equals((Object)WorkspaceItemAction.CREATED)) {
                logger.info("update LAST_MODIFIED from: " + node.getProperty(NodeProperty.LAST_MODIFIED.toString()).getDate().getTime() + " to " + this.item.getLastModificationTime().getTime());
                node.setProperty(NodeProperty.LAST_MODIFIED.toString(), this.item.getLastModificationTime());
            } else {
                logger.info("LAST_MODIFIED property will be automatically created ");
            }
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.LAST_MODIFIED);
        }
        try {
            if (node.hasProperty(NodeProperty.LAST_ACTION.toString())) {
                logger.info("update LAST_ACTION from: " + node.getProperty(NodeProperty.LAST_ACTION.toString()).getString() + " to " + this.item.getLastAction().toString());
            } else {
                logger.info("setting LAST_ACTION to: " + this.item.getLastAction());
            }
            node.setProperty(NodeProperty.LAST_ACTION.toString(), this.item.getLastAction().toString());
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.LAST_ACTION);
        }
        try {
            logger.info("update METADATA");
            Node metadata = node.getNode(NodeProperty.METADATA.toString());
            Map map = this.item.getMetadata();
            if (map != null) {
                Set keys = map.keySet();
                for (String key : keys) {
                    String value = (String)map.get(key);
                    logger.info("Add key [" + key + ": " + value + "]");
                    metadata.setProperty(key, value);
                }
            }
        }
        catch (RepositoryException e) {
            logger.info("error setting " + NodeProperty.METADATA);
        }
    }

    private ItemDelegate getItemDelegate(Node node, String login) throws RepositoryException, InternalErrorException {
        NodeManager myNode = null;
        try {
            myNode = new NodeManager(node, login);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myNode.getItemDelegate();
    }

    private void setCustomProperties(Node node, ItemDelegate item) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        String type = item.getPrimaryType();
        logger.info(type);
        Node contentNode = null;
        switch (type) {
            case "nthl:workspaceItem": {
                break;
            }
            case "nthl:workspaceSharedItem": {
                try {
                    node.setProperty(NodeProperty.DISPLAY_NAME.toString(), (String)item.getProperties().get(NodeProperty.DISPLAY_NAME));
                }
                catch (Exception e) {
                    logger.error(NodeProperty.DISPLAY_NAME + " not present");
                }
                try {
                    node.setProperty(NodeProperty.IS_VRE_FOLDER.toString(), ((Boolean)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.IS_VRE_FOLDER))).booleanValue());
                }
                catch (Exception e) {
                    logger.error(NodeProperty.IS_VRE_FOLDER + " not present");
                }
                Node usersNode = node.getNode(NodeProperty.USERS.toString());
                try {
                    Map users = (Map)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.USERS));
                    Set set = users.keySet();
                    for (String user : set) {
                        usersNode.setProperty(user, (String)users.get(user));
                    }
                }
                catch (Exception e) {
                    logger.error(NodeProperty.USERS + " not present");
                }
                Node membersNode = node.getNode(NodeProperty.MEMBERS.toString());
                try {
                    List users = (List)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.MEMBERS));
                    for (String user : users) {
                        if (membersNode.hasNode(user)) continue;
                        membersNode.addNode(user);
                    }
                    break;
                }
                catch (Exception e) {
                    logger.error(NodeProperty.MEMBERS + " not present");
                    break;
                }
            }
            case "nthl:externalFile": {
                try {
                    contentNode = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNode = node.addNode(NodeProperty.CONTENT.toString(), ContentType.GENERAL.toString());
                }
                this.setFileProperties(item.getContent(), contentNode);
                break;
            }
            case "nthl:externalImage": {
                try {
                    contentNode = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNode = node.addNode(NodeProperty.CONTENT.toString(), ContentType.IMAGE.toString());
                }
                this.setPropOnImgFile(contentNode, item.getContent());
                break;
            }
            case "nthl:externalPdf": {
                try {
                    contentNode = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNode = node.addNode(NodeProperty.CONTENT.toString(), ContentType.PDF.toString());
                }
                this.setPropOnPdfFile(contentNode, item.getContent());
                break;
            }
            case "nthl:externalUrl": {
                logger.info("URL");
                try {
                    contentNode = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNode = node.addNode(NodeProperty.CONTENT.toString(), ContentType.GENERAL.toString());
                }
                this.setPropOnUrl(contentNode, item.getContent());
                break;
            }
            case "nthl:gCubeItem": {
                List scopes = (List)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.SCOPES));
                node.setProperty(NodeProperty.SCOPES.toString(), scopes.toArray(new String[0]));
                node.setProperty(NodeProperty.CREATOR.toString(), (String)item.getProperties().get(NodeProperty.CREATOR));
                node.setProperty(NodeProperty.ITEM_TYPE.toString(), (String)item.getProperties().get(NodeProperty.ITEM_TYPE));
                node.setProperty(NodeProperty.IS_SHARED.toString(), ((Boolean)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.IS_SHARED))).booleanValue());
                try {
                    node.setProperty(NodeProperty.SHARED_ROOT_ID.toString(), (String)item.getProperties().get(NodeProperty.SHARED_ROOT_ID));
                }
                catch (Exception e) {
                    logger.error(NodeProperty.SHARED_ROOT_ID + " not present");
                }
                break;
            }
            case "nthl:trashItem": {
                node.setProperty(NodeProperty.TRASH_ITEM_NAME.toString(), (String)item.getProperties().get(NodeProperty.TRASH_ITEM_NAME));
                node.setProperty(NodeProperty.DELETE_DATE.toString(), (Calendar)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.DELETE_DATE)));
                node.setProperty(NodeProperty.DELETE_BY.toString(), (String)item.getProperties().get(NodeProperty.DELETE_BY));
                node.setProperty(NodeProperty.DELETED_FROM.toString(), (String)item.getProperties().get(NodeProperty.DELETED_FROM));
                node.setProperty(NodeProperty.ORIGINAL_PARENT_ID.toString(), (String)item.getProperties().get(NodeProperty.ORIGINAL_PARENT_ID));
                node.setProperty(NodeProperty.TRASH_ITEM_MIME_TYPE.toString(), (String)item.getProperties().get(NodeProperty.TRASH_ITEM_MIME_TYPE));
                node.setProperty(NodeProperty.LENGTH.toString(), (String)item.getProperties().get(NodeProperty.LENGTH));
                node.setProperty(NodeProperty.IS_FOLDER.toString(), ((Boolean)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.IS_FOLDER))).booleanValue());
                break;
            }
            case "nthl:timeSeriesItem": {
                Node contentNodeTS;
                node.setProperty(NodeProperty.FOLDER_ITEM_TYPE.toString(), (String)item.getProperties().get(NodeProperty.FOLDER_ITEM_TYPE));
                try {
                    contentNodeTS = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNodeTS = node.addNode(NodeProperty.CONTENT.toString(), ContentType.TS.toString());
                }
                Map content = item.getContent();
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_CREATED.toString(), (String)content.get(NodeProperty.TIMESERIES_CREATED));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_CREATOR.toString(), (String)content.get(NodeProperty.CREATOR));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_DESCRIPTION.toString(), (String)content.get(NodeProperty.DESCRIPTION));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_DIMENSION.toString(), ((Long)this.xstream.fromXML((String)content.get(NodeProperty.TIMESERIES_DIMENSION))).longValue());
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_ID.toString(), (String)content.get(NodeProperty.TIMESERIES_ID));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_PUBLISHER.toString(), (String)content.get(NodeProperty.TIMESERIES_PUBLISHER));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_RIGHTS.toString(), (String)content.get(NodeProperty.TIMESERIES_RIGHTS));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_SOURCE_ID.toString(), (String)content.get(NodeProperty.TIMESERIES_SOURCE_ID));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_SOURCE_NAME.toString(), (String)content.get(NodeProperty.TIMESERIES_SOURCE_NAME));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_TITLE.toString(), (String)content.get(NodeProperty.TIMESERIES_TITLE));
                List headerLabels = (List)this.xstream.fromXML((String)content.get(NodeProperty.HEADER_LABELS));
                contentNodeTS.setProperty(NodeProperty.HEADER_LABELS.toString(), headerLabels.toArray(new String[headerLabels.size()]));
                break;
            }
            case "nthl:query": {
                Node contentNodeQuery;
                node.setProperty(NodeProperty.FOLDER_ITEM_TYPE.toString(), (String)item.getProperties().get(NodeProperty.FOLDER_ITEM_TYPE));
                try {
                    contentNodeQuery = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNodeQuery = node.addNode(NodeProperty.CONTENT.toString(), ContentType.QUERY.toString());
                }
                contentNodeQuery.setProperty(NodeProperty.QUERY.toString(), (String)item.getContent().get(NodeProperty.QUERY));
                contentNodeQuery.setProperty(NodeProperty.QUERY_TYPE.toString(), (String)item.getContent().get(NodeProperty.QUERY_TYPE));
                break;
            }
            case "nthl:workspaceLeafItem": {
                Node contentNodeLeaf;
                try {
                    contentNodeLeaf = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNodeLeaf = node.addNode(NodeProperty.CONTENT.toString(), (String)item.getContent().get(NodeProperty.CONTENT));
                }
                if (!((String)item.getContent().get(NodeProperty.CONTENT)).equals(ContentType.SMART.toString())) break;
                contentNodeLeaf.setProperty(NodeProperty.QUERY.toString(), (String)item.getContent().get(NodeProperty.QUERY));
                break;
            }
            case "nthl:report": {
                Node contentNodeR;
                try {
                    contentNodeR = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNodeR = node.addNode(NodeProperty.CONTENT.toString(), ContentType.REPORT.toString());
                }
                this.setFileProperties(item.getContent(), contentNodeR);
                contentNodeR.setProperty(NodeProperty.TEMPLATE_NAME.toString(), (String)item.getContent().get(NodeProperty.TEMPLATE_NAME));
                contentNodeR.setProperty(NodeProperty.AUTHOR.toString(), (String)item.getContent().get(NodeProperty.AUTHOR));
                contentNodeR.setProperty(NodeProperty.RT_CREATED.toString(), (Calendar)this.xstream.fromXML((String)item.getContent().get(NodeProperty.RT_CREATED)));
                contentNodeR.setProperty(NodeProperty.LAST_EDIT.toString(), (Calendar)this.xstream.fromXML((String)item.getContent().get(NodeProperty.LAST_EDIT)));
                contentNodeR.setProperty(NodeProperty.LAST_EDIT_BY.toString(), (String)item.getContent().get(NodeProperty.LAST_EDIT_BY));
                contentNodeR.setProperty(NodeProperty.NUMBER_OF_SECTION.toString(), (long)((Integer)this.xstream.fromXML((String)item.getContent().get(NodeProperty.NUMBER_OF_SECTION))).intValue());
                contentNodeR.setProperty(NodeProperty.STATUS.toString(), (String)item.getContent().get(NodeProperty.STATUS));
                break;
            }
            case "nthl:reportTemplate": {
                Node contentNodeRT;
                try {
                    contentNodeRT = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNodeRT = node.addNode(NodeProperty.CONTENT.toString(), ContentType.REPORT_TEMPLATE.toString());
                }
                this.setFileProperties(item.getContent(), contentNodeRT);
                contentNodeRT.setProperty(NodeProperty.AUTHOR.toString(), (String)item.getContent().get(NodeProperty.AUTHOR));
                contentNodeRT.setProperty(NodeProperty.RT_CREATED.toString(), (Calendar)this.xstream.fromXML((String)item.getContent().get(NodeProperty.RT_CREATED)));
                contentNodeRT.setProperty(NodeProperty.LAST_EDIT.toString(), (Calendar)this.xstream.fromXML((String)item.getContent().get(NodeProperty.LAST_EDIT)));
                contentNodeRT.setProperty(NodeProperty.LAST_EDIT_BY.toString(), (String)item.getContent().get(NodeProperty.LAST_EDIT_BY));
                contentNodeRT.setProperty(NodeProperty.NUMBER_OF_SECTION.toString(), (long)((Integer)this.xstream.fromXML((String)item.getContent().get(NodeProperty.NUMBER_OF_SECTION))).intValue());
                contentNodeRT.setProperty(NodeProperty.STATUS.toString(), (String)item.getContent().get(NodeProperty.STATUS));
                break;
            }
            case "nthl:itemSentRequest": {
                node.setProperty(NodeProperty.SUBJECT.toString(), (String)item.getProperties().get(NodeProperty.SUBJECT));
                node.setProperty(NodeProperty.BODY.toString(), (String)item.getProperties().get(NodeProperty.BODY));
                node.setProperty(NodeProperty.READ.toString(), ((Boolean)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.READ))).booleanValue());
                node.setProperty(NodeProperty.OPEN.toString(), ((Boolean)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.OPEN))).booleanValue());
                List addresses = (List)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.ADDRESSES));
                node.setProperty(NodeProperty.ADDRESSES.toString(), addresses.toArray(new String[addresses.size()]));
                logger.info("addresses: " + addresses.toArray(new String[addresses.size()]).toString());
                List attachments = (List)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.ATTACHMENTS));
                node.setProperty(NodeProperty.ATTACHMENTS.toString(), attachments.toArray(new String[attachments.size()]));
                logger.info("attachments: " + attachments.toArray(new String[attachments.size()]).toString());
                break;
            }
        }
    }

    private void setPropOnUrl(Node contentNode, Map<NodeProperty, String> map) {
        try {
            this.setFileProperties(map, contentNode);
        }
        catch (Exception e) {
            logger.error("Error setting properties on file ");
        }
    }

    private void setPropOnImgFile(Node contentNode, Map<NodeProperty, String> map) throws RepositoryException {
        try {
            this.setFileProperties(map, contentNode);
        }
        catch (Exception e) {
            logger.error("Error setting properties on file ");
        }
        try {
            if (contentNode.hasProperty(NodeProperty.IMAGE_WIDTH.toString())) {
                logger.info("update IMAGE_WIDTH from: " + contentNode.getProperty(NodeProperty.IMAGE_WIDTH.toString()).getLong() + " to " + this.xstream.fromXML(map.get(NodeProperty.IMAGE_WIDTH)));
            } else {
                logger.info("setting IMAGE_WIDTH to: " + this.xstream.fromXML(map.get(NodeProperty.IMAGE_WIDTH)));
            }
            contentNode.setProperty(NodeProperty.IMAGE_WIDTH.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.IMAGE_WIDTH))).intValue());
            contentNode.setProperty(NodeProperty.IMAGE_HEIGHT.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.IMAGE_HEIGHT))).intValue());
            contentNode.setProperty(NodeProperty.THUMBNAIL_WIDTH.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.THUMBNAIL_WIDTH))).intValue());
            contentNode.setProperty(NodeProperty.THUMBNAIL_HEIGHT.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.THUMBNAIL_HEIGHT))).intValue());
        }
        catch (Exception e) {
            logger.error("Error setting properties on image " + contentNode.getPath(), (Throwable)e);
        }
    }

    private void setPropOnPdfFile(Node contentNode, Map<NodeProperty, String> map) {
        try {
            this.setFileProperties(map, contentNode);
        }
        catch (Exception e) {
            logger.error("Error setting properties on file ");
        }
        try {
            contentNode.setProperty(NodeProperty.NUMBER_OF_PAGES.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.NUMBER_OF_PAGES))).intValue());
            contentNode.setProperty(NodeProperty.VERSION.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.VERSION)));
            contentNode.setProperty(NodeProperty.AUTHOR.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.AUTHOR)));
            contentNode.setProperty(NodeProperty.PDF_TITLE.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.PDF_TITLE)));
            contentNode.setProperty(NodeProperty.PRODUCER.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.PRODUCER)));
        }
        catch (Exception e) {
            logger.error("Error setting custom properties on pdf file ");
        }
    }

    private void setFileProperties(Map<NodeProperty, String> delegateContent, Node nodeContent) throws RepositoryException {
        logger.info(nodeContent.getPath() + " added - type: " + nodeContent.getPrimaryNodeType().getName());
        try {
            if (nodeContent.hasProperty(NodeProperty.MIME_TYPE.toString())) {
                logger.info("update MIME_TYPE from: " + nodeContent.getProperty(NodeProperty.MIME_TYPE.toString()).getString() + " to " + delegateContent.get(NodeProperty.MIME_TYPE));
            } else {
                logger.info("setting MIME_TYPE to: " + delegateContent.get(NodeProperty.MIME_TYPE));
            }
            nodeContent.setProperty(NodeProperty.MIME_TYPE.toString(), delegateContent.get(NodeProperty.MIME_TYPE));
        }
        catch (Exception e) {
            logger.error("error setting propery " + NodeProperty.MIME_TYPE, (Throwable)e);
        }
        try {
            Long size = (Long)new XStream().fromXML(delegateContent.get(NodeProperty.SIZE));
            nodeContent.setProperty(NodeProperty.SIZE.toString(), size.longValue());
        }
        catch (Exception e) {
            logger.error("error setting propery " + NodeProperty.SIZE, (Throwable)e);
        }
        try {
            if (nodeContent.hasProperty(NodeProperty.REMOTE_STORAGE_PATH.toString())) {
                logger.info("update REMOTE_STORAGE_PATH from: " + nodeContent.getProperty(NodeProperty.REMOTE_STORAGE_PATH.toString()).getString() + " to " + delegateContent.get(NodeProperty.REMOTE_STORAGE_PATH));
            } else {
                logger.info("setting REMOTE_STORAGE_PATH to: " + delegateContent.get(NodeProperty.REMOTE_STORAGE_PATH));
            }
            String remotePath = delegateContent.get(NodeProperty.REMOTE_STORAGE_PATH);
            nodeContent.setProperty(NodeProperty.REMOTE_STORAGE_PATH.toString(), remotePath);
        }
        catch (Exception e) {
            logger.error("error setting propery " + NodeProperty.REMOTE_STORAGE_PATH, (Throwable)e);
        }
        try {
            ByteArrayInputStream binaryUrl = new ByteArrayInputStream(nodeContent.getPath().getBytes());
            Binary binary = nodeContent.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
            nodeContent.setProperty(NodeProperty.DATA.toString(), binary);
        }
        catch (Exception e) {
            logger.info("error setting propery " + NodeProperty.DATA);
        }
    }

    public ItemDelegate save(Session session) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        try {
            String id = this.item.getId();
            if (id == null) {
                logger.info("Create a new node");
                ItemDelegate myItem = this.addNode(session);
                return myItem;
            }
            logger.info("Modify an existing node, id: " + id);
            Node node = session.getNodeByIdentifier(id);
            this.setProperties(node);
            this.setCustomProperties(node, this.item);
            node.getSession().save();
        }
        catch (Exception e) {
            logger.error("impossible to save item delegate", (Throwable)e);
        }
        return this.item;
    }
}

