/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import com.thoughtworks.xstream.XStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceFolder;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceItem;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceMessage;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceSharedFolder;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceTrashItem;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalFile;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalImage;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalPDFFile;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalUrl;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRGCubeItem;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRQuery;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRReport;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRReportTemplate;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRTimeSeries;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRImageDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRMetadata;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRPDFDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRUrlDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.search.JCRSearchFolder;
import org.apache.jackrabbit.j2ee.workspacemanager.search.JCRSearchFolderItem;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibrary.model.exceptions.InternalErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManager {
    private static Logger logger = LoggerFactory.getLogger(NodeManager.class);
    Node node;
    String login;
    XStream xstream;

    public NodeManager(Node node, String login) throws Exception {
        this.node = node;
        this.login = login;
    }

    public ItemDelegate getItemDelegate() throws RepositoryException, InternalErrorException {
        String type;
        switch (type = this.node.getPrimaryNodeType().getName()) {
            case "rep:root": {
                return new JCRWorkspaceFolder(this.node, this.login).getItemDelegate();
            }
            case "nthl:home": {
                return new JCRWorkspaceItem(this.node, this.login).getItemDelegate();
            }
            case "nt:folder": {
                return new JCRWorkspaceFolder(this.node, this.login).getItemDelegate();
            }
            case "nthl:workspaceLeafItem": {
                return new JCRWorkspaceFolder(this.node, this.login).getItemDelegate();
            }
            case "nthl:workspaceItem": {
                return new JCRWorkspaceFolder(this.node, this.login).getItemDelegate();
            }
            case "nthl:workspaceSharedItem": {
                return new JCRWorkspaceSharedFolder(this.node, this.login).getItemDelegate();
            }
            case "nthl:externalFile": {
                return new JCRExternalFile(this.node, this.login).getItemDelegate();
            }
            case "nthl:externalImage": {
                return new JCRExternalImage(this.node, this.login).getItemDelegate();
            }
            case "nthl:externalPdf": {
                return new JCRExternalPDFFile(this.node, this.login).getItemDelegate();
            }
            case "nthl:externalUrl": {
                return new JCRExternalUrl(this.node, this.login).getItemDelegate();
            }
            case "nthl:gCubeItem": {
                return new JCRGCubeItem(this.node, this.login).getItemDelegate();
            }
            case "nthl:trashItem": {
                return new JCRWorkspaceTrashItem(this.node, this.login).getItemDelegate();
            }
            case "nthl:itemSentRequest": {
                return new JCRWorkspaceMessage(this.node, this.login).getItemDelegate();
            }
            case "nthl:rootItemSentRequest": {
                return new JCRWorkspaceFolder(this.node, this.login).getItemDelegate();
            }
            case "nthl:timeSeriesItem": {
                return new JCRTimeSeries(this.node, this.login).getItemDelegate();
            }
            case "nthl:query": {
                return new JCRQuery(this.node, this.login).getItemDelegate();
            }
            case "nthl:report": {
                return new JCRReport(this.node, this.login).getItemDelegate();
            }
            case "nthl:reportTemplate": {
                return new JCRReportTemplate(this.node, this.login).getItemDelegate();
            }
            case "nthl:gCubeDocument": {
                return new JCRDocument(this.node, this.login).getItemDelegate();
            }
            case "nthl:gCubeImageDocument": {
                return new JCRImageDocument(this.node, this.login).getItemDelegate();
            }
            case "nthl:gCubePDFDocument": {
                return new JCRPDFDocument(this.node, this.login).getItemDelegate();
            }
            case "nthl:gCubeURLDocument": {
                return new JCRUrlDocument(this.node, this.login).getItemDelegate();
            }
            case "nthl:gCubeMetadata": {
                return new JCRMetadata(this.node, this.login).getItemDelegate();
            }
        }
        throw new InternalErrorException("JCR node type unknow");
    }

    public SearchItemDelegate getSearchItem(String itemName) throws RepositoryException, InternalErrorException {
        String type = this.node.getPrimaryNodeType().getName();
        if (type.equals("nthl:workspaceItem") || type.equals("nthl:workspaceSharedItem")) {
            return new JCRSearchFolder(this.node, itemName).getSearchItemDelegate();
        }
        return new JCRSearchFolderItem(this.node, itemName).getSearchItemDelegate();
    }
}

