/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.get;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetParentById
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetParentById.class);
    public static final String NT_WORKSPACE_TRASH = "nthl:trashFolder";
    public static final String NT_WORKSPACE_FOLDER = "nthl:workspaceItem";
    public static final String NT_WORKSPACE_SHARED_FOLDER = "nthl:workspaceSharedItem";
    public static final String NT_WORKSPACE_FOLDER_ITEM = "nthl:workspaceLeafItem";
    public static final String NT_WORKSPACE_FILE = "nthl:externalFile";
    public static final String NT_WORKSPACE_IMAGE = "nthl:externalImage";
    public static final String NT_WORKSPACE_PDF_FILE = "nthl:externalPdf";
    public static final String NT_WORKSPACE_URL = "nthl:externalUrl";
    public static final String NT_GCUBE_ITEM = "nthl:gCubeItem";
    public static final String NT_TRASH_ITEM = "nthl:trashItem";
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String id = request.getParameter("id");
        String login = request.getParameter("login");
        logger.info("Servlet GetParentById called with parameters: [id: " + id + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        ItemDelegate parent = null;
        try {
            xstream = new XStream();
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
            parent = this.getParent(session, id, login);
            xmlConfig = xstream.toXML((Object)parent);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }

    private ItemDelegate getParent(SessionImpl session, String identifier, String login) throws Exception {
        Node node = session.getNodeByIdentifier(identifier).getParent();
        NodeManager wrap = new NodeManager(node, login);
        ItemDelegate item = null;
        try {
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }
}

