/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.session;

import java.security.MessageDigest;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.j2ee.workspacemanager.session.MySession;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.homelibary.model.util.Cleanable;
import org.gcube.common.homelibary.model.util.MemoryCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private static MemoryCache<String, MySession> cache;
    private static SessionManager sessionManager;
    private static Repository rep;
    private static long timeToLiveInSeconds;
    private static long timerIntervalInSeconds;
    private static int maxItems;
    private static final Object REPOSITORY_LOCK;

    private SessionManager() {
        cache = new MemoryCache(timeToLiveInSeconds, timerIntervalInSeconds, maxItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionManager getInstance(Repository repository) {
        if (sessionManager == null) {
            Object object = REPOSITORY_LOCK;
            synchronized (object) {
                rep = repository;
                if (sessionManager == null) {
                    sessionManager = new SessionManager();
                }
            }
        }
        return sessionManager;
    }

    public Session getSession(String sessionId) {
        Session session = null;
        MySession cacheValue = (MySession)cache.get((Object)sessionId);
        if (cacheValue != null) {
            return cacheValue.getSession();
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session newSession(HttpServletRequest request) throws Exception {
        String user = request.getSession().getServletContext().getInitParameter("user");
        char[] pass = request.getSession().getServletContext().getInitParameter("pass").toCharArray();
        Session session = null;
        try {
            Object object = REPOSITORY_LOCK;
            synchronized (object) {
                session = rep.login((Credentials)new SimpleCredentials(user, pass));
            }
            cache.put((Object)session.toString(), (Cleanable)new MySession(this.getLogin(request), session));
        }
        catch (Exception e) {
            logger.error("Error getting new session for user " + user + " : ", (Throwable)e);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session newSession(HttpServletRequest request, String login) throws Exception {
        logger.trace("Getting a new session for user " + this.getLogin(request));
        Session session = null;
        try {
            Object object = REPOSITORY_LOCK;
            synchronized (object) {
                session = rep.login((Credentials)new SimpleCredentials(this.getLogin(request), this.getSecurePassword(this.getLogin(request)).toCharArray()));
            }
        }
        catch (Exception e) {
            logger.error("Error getting new session for user " + login, (Throwable)e);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session newSession(String login) throws Exception {
        logger.trace("Getting a new session for user " + login);
        Session session = null;
        try {
            Object object = REPOSITORY_LOCK;
            synchronized (object) {
                session = rep.login((Credentials)new SimpleCredentials(login, this.getSecurePassword(login).toCharArray()));
            }
            cache.put((Object)session.toString(), (Cleanable)new MySession(login, session));
        }
        catch (Exception e) {
            throw new Exception("Error getting a new session for user " + login, e);
        }
        return session;
    }

    public String getLogin(HttpServletRequest request) throws Exception {
        String login = request.getParameter("login");
        if (login == null) {
            AuthorizationEntry entry = null;
            try {
                entry = Constants.authorizationService().get(SecurityTokenProvider.instance.get());
                login = entry.getClientInfo().getId();
            }
            catch (Exception e) {
                throw new Exception("User not authorize to access Home Library Webapp", e);
            }
        }
        return login;
    }

    public String getSecurePassword(String user) throws Exception {
        String digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(user.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            digest = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return digest;
    }

    public void releaseSession(String id) {
        cache.remove((Object)id);
    }

    public boolean sessionExists(String uuid) {
        return cache.containsKey((Object)uuid);
    }

    public Set<String> getSessionIds() {
        return cache.keySet();
    }

    public String getLogin(String sessionId) {
        return ((MySession)cache.get((Object)sessionId)).getUser();
    }

    static {
        sessionManager = null;
        rep = null;
        timeToLiveInSeconds = 3600L;
        timerIntervalInSeconds = 7200L;
        maxItems = 10000;
        REPOSITORY_LOCK = new Object();
    }
}

