/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.ItemDelegateWrapper;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.model.exceptions.InternalErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetServlets
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetServlets.class);
    private static final long serialVersionUID = 1L;
    public static final String PATH_SEPARATOR = "/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    public static final String HL_NAMESPACE = "hl:";
    public static final String JCR_NAMESPACE = "jcr:";
    public static final String REP_NAMESPACE = "rep:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            String servlet;
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(login, user, pass);
                sessionId = session.toString();
            }
            StringBuffer requestURL = request.getRequestURL();
            switch (servlet = requestURL.toString().substring(requestURL.lastIndexOf(PATH_SEPARATOR) + 1, requestURL.length())) {
                case "ExecuteQuery": {
                    String query = null;
                    String lang = null;
                    String limit = null;
                    try {
                        query = new String(request.getParameter("query").getBytes("iso-8859-1"), "UTF-8");
                        lang = request.getParameter("lang");
                        limit = request.getParameter("limit");
                        logger.info("Servlet ExecuteQuery called with parameters: [query: " + query + " - lang: " + lang + " - login: " + login + " - limit: " + limit + "]");
                        List children = this.execute(session, query, lang, login, Integer.parseInt(limit));
                        xmlConfig = xstream.toXML((Object)children);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error executing query: " + query + "- lang: " + lang + " - limit: " + limit, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "GetChildrenById": {
                    String itemId1 = null;
                    Boolean showHidden = false;
                    try {
                        itemId1 = request.getParameter("id");
                        showHidden = Boolean.parseBoolean(request.getParameter("showHidden"));
                        List children = this.getChildren(session, itemId1, login, showHidden);
                        xmlConfig = xstream.toXML((Object)children);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error getting children by id: " + itemId1, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "GetParentsById": {
                    String myId = null;
                    try {
                        myId = request.getParameter("id");
                        List children = this.getParentsById(session, myId, login);
                        xmlConfig = xstream.toXML((Object)children);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error getting parents items by id: " + myId, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "GetHiddenItemsById": {
                    String myItem = null;
                    try {
                        myItem = request.getParameter("id");
                        List children = this.getHiddenItems(session, myItem, login);
                        xmlConfig = xstream.toXML((Object)children);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error getting hidden items by id: " + myItem, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "GetItemById": {
                    String itemId11 = null;
                    try {
                        itemId11 = request.getParameter("id");
                        ItemDelegate item = this.getDelegateItemById(session, itemId11, login);
                        xmlConfig = xstream.toXML((Object)item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error getting item by id: " + itemId11, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "GetItemByPath": {
                    String path = null;
                    try {
                        path = new String(request.getParameter("path").getBytes("iso-8859-1"), "UTF-8");
                        logger.info("Servlet GetItemByPath called with parameters: [path: " + path + "]");
                        ItemDelegate item = this.getDelegateItemByPath(session, path, login);
                        xmlConfig = xstream.toXML((Object)item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (PathNotFoundException e) {
                        logger.error("PathNotFoundException: " + path);
                        xmlConfig = xstream.toXML((Object)(path + " Path Not Found"));
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "SearchItems": {
                    List children = null;
                    String query1 = null;
                    String lang1 = null;
                    try {
                        query1 = request.getParameter("query");
                        lang1 = request.getParameter("lang");
                        logger.info("Servlet SearchItems called with parameters: [query: " + query1 + " - lang: " + lang1 + "]");
                        children = this.execute(session, query1, lang1, login);
                        xmlConfig = xstream.toXML((Object)children);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error searching items by query: " + query1 + " - lang: " + lang1, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "Clone": {
                    String srcAbsPath = null;
                    String destAbsPath = null;
                    String removeExisting = null;
                    try {
                        srcAbsPath = new String(request.getParameter("srcAbsPath").getBytes("iso-8859-1"), "UTF-8");
                        destAbsPath = new String(request.getParameter("destAbsPath").getBytes("iso-8859-1"), "UTF-8");
                        removeExisting = request.getParameter("removeExisting");
                        logger.info("Servlet Clone called with parameters: [srcAbsPath: " + srcAbsPath + " - destAbsPath: " + destAbsPath + " - removeExisting: " + removeExisting + "]");
                        ItemDelegate new_item = this.cloneItem(session, srcAbsPath, destAbsPath, Boolean.valueOf(removeExisting).booleanValue(), login);
                        xmlConfig = xstream.toXML((Object)new_item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error cloning item from path: " + srcAbsPath + " - to: " + destAbsPath + " - removeExisting? " + removeExisting, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "Copy": {
                    String srcAbsPath1 = null;
                    String destAbsPath1 = null;
                    try {
                        srcAbsPath1 = new String(request.getParameter("srcAbsPath").getBytes("iso-8859-1"), "UTF-8");
                        destAbsPath1 = new String(request.getParameter("destAbsPath").getBytes("iso-8859-1"), "UTF-8");
                        logger.info("Servlet Copy called with parameters: [srcAbsPath: " + srcAbsPath1 + " - destAbsPath: " + destAbsPath1 + "]");
                        ItemDelegate new_item = this.copyItem(session, srcAbsPath1, destAbsPath1, login);
                        xmlConfig = xstream.toXML((Object)new_item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error copying item from path: " + srcAbsPath1 + " - to: " + destAbsPath1, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "CreateReference": {
                    String srcID = null;
                    String destID = null;
                    try {
                        srcID = request.getParameter("srcId");
                        destID = request.getParameter("destId");
                        logger.info("Servlet CreateReference called with parameters: [srcID: " + srcID + " - destID: " + destID + "]");
                        ItemDelegate new_item = this.createReference(session, srcID, destID, login);
                        xmlConfig = xstream.toXML((Object)new_item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error creating reference of node id: " + srcID + " - to destination id: " + destID, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "Move": {
                    String srcAbsPath11 = null;
                    String destAbsPath11 = null;
                    try {
                        srcAbsPath11 = new String(request.getParameter("srcAbsPath").getBytes("iso-8859-1"), "UTF-8");
                        destAbsPath11 = new String(request.getParameter("destAbsPath").getBytes("iso-8859-1"), "UTF-8");
                        logger.info("Servlet Move called with parameters: [srcAbsPath11: " + srcAbsPath11 + " - destAbsPath11: " + destAbsPath11 + "]");
                        ItemDelegate new_item = this.moveItem(session, srcAbsPath11, destAbsPath11, login);
                        xmlConfig = xstream.toXML((Object)new_item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error moving item from path: " + srcAbsPath11 + " - to: " + destAbsPath11, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "CopyContent": {
                    String srcAbsPath111 = null;
                    String destAbsPath111 = null;
                    try {
                        srcAbsPath111 = new String(request.getParameter("srcAbsPath").getBytes("iso-8859-1"), "UTF-8");
                        destAbsPath111 = new String(request.getParameter("destAbsPath").getBytes("iso-8859-1"), "UTF-8");
                        logger.info("Servlet CopyContent called with parameters: [srcAbsPath11: " + srcAbsPath111 + " - destAbsPath11: " + destAbsPath111 + "]");
                        ItemDelegate new_item = this.copyContetItem(session, srcAbsPath111, destAbsPath111, login);
                        xmlConfig = xstream.toXML((Object)new_item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error moving item from path: " + srcAbsPath111 + " - to: " + destAbsPath111, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "RemoveItem": {
                    String absPath = null;
                    try {
                        absPath = request.getParameter("absPath");
                        logger.info("Servlet RemoveItem called with parameters: [absPath: " + absPath + "]");
                        this.remove(session, absPath);
                        xmlConfig = xstream.toXML((Object)"Item removed");
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error removing item by path: " + absPath, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "SaveItem": {
                    ItemDelegate item = null;
                    try {
                        item = (ItemDelegate)xstream.fromXML((InputStream)request.getInputStream());
                        logger.info("Servlet saveItem called on item: " + item.getName());
                        ItemDelegateWrapper wrapper = new ItemDelegateWrapper(item, "");
                        ItemDelegate new_item = wrapper.save((Session)session);
                        xmlConfig = xstream.toXML((Object)new_item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error saving item with id: " + item.getId(), (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "LockSession": {
                    String uuid = null;
                    String id = null;
                    try {
                        uuid = request.getParameter("uuid");
                        id = request.getParameter("id");
                        LockManager lockManager = session.getWorkspace().getLockManager();
                        Lock lock = lockManager.lock(session.getNodeByIdentifier(id).getPath(), true, true, 0L, "");
                        logger.trace("LOCK on Node: " + lock.getNode().getPath());
                        session.save();
                        xmlConfig = xstream.toXML((Object)("Node id " + id + " locked in session " + uuid));
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error locking item with id: " + id + " in session " + uuid, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "UnlockSession": {
                    String uuid1 = null;
                    String id1 = null;
                    try {
                        uuid1 = request.getParameter("uuid");
                        id1 = request.getParameter("id");
                        LockManager lockManager = session.getWorkspace().getLockManager();
                        String pathNode = session.getNodeByIdentifier(id1).getPath();
                        if (lockManager.isLocked(pathNode)) {
                            lockManager.unlock(pathNode);
                            logger.trace("Remove Lock from node: " + pathNode);
                        }
                        xmlConfig = xstream.toXML((Object)("Node id " + id1 + " unlocked in session " + uuid1));
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error unlocking item with id: " + id1 + " in session " + uuid1, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "IsLocked": {
                    String id11 = null;
                    boolean flag = false;
                    try {
                        id11 = request.getParameter("id");
                        LockManager lockManager = session.getWorkspace().getLockManager();
                        String pathNode = session.getNodeByIdentifier(id11).getPath();
                        if (lockManager.isLocked(pathNode)) {
                            flag = true;
                            logger.trace(pathNode + " is locked");
                        }
                        xmlConfig = xstream.toXML((Object)flag);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error in islock servlet ", (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "ActiveSessions": {
                    ArrayList<String> ids = new ArrayList<String>();
                    try {
                        Set list = sessionManager.getSessionIds();
                        Iterator i$ = list.iterator();
                        while (true) {
                            if (!i$.hasNext()) {
                                xmlConfig = xstream.toXML(ids);
                                response.setContentLength(xmlConfig.length());
                                out.println(xmlConfig);
                                return;
                            }
                            String sessionId1 = (String)i$.next();
                            ids.add(sessionId1);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error ActiveSessions", (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
            return;
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private List<ItemDelegate> getParentsById(SessionImpl session, String identifier, String login) throws Exception {
        Node node = session.getNodeByIdentifier(identifier);
        ArrayList<ItemDelegate> parents = new ArrayList<ItemDelegate>();
        while (!this.isRoot(node)) {
            ItemDelegate item = null;
            NodeManager wrap = new NodeManager(node, login);
            try {
                item = wrap.getItemDelegate();
                parents.add(item);
                if (login != null && item.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                    Map users = (Map)new XStream().fromXML((String)item.getProperties().get(NodeProperty.USERS));
                    String[] user = ((String)users.get(login)).split(PATH_SEPARATOR);
                    String parentId = user[0];
                    node = session.getNodeByIdentifier(parentId);
                    continue;
                }
                node = node.getParent();
            }
            catch (Exception e) {
                logger.error("Error getting parents by id " + e);
            }
        }
        return parents;
    }

    public boolean isRoot(Node node) throws InternalErrorException, RepositoryException {
        Node parent = null;
        try {
            parent = node.getParent();
        }
        catch (ItemNotFoundException e) {
            return true;
        }
        return parent == null;
    }

    private List<ItemDelegate> getHiddenItems(SessionImpl session, String identifier, String login) throws Exception {
        Node folderNode = session.getNodeByIdentifier(identifier);
        NodeIterator iterator = folderNode.getNodes();
        ArrayList<ItemDelegate> children = new ArrayList<ItemDelegate>();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            Boolean isHidden = false;
            if (node.hasProperty(NodeProperty.HIDDEN.toString())) {
                isHidden = node.getProperty(NodeProperty.HIDDEN.toString()).getBoolean();
            }
            if (!isHidden.booleanValue()) continue;
            ItemDelegate item = null;
            NodeManager wrap = new NodeManager(node, login);
            try {
                item = wrap.getItemDelegate();
                children.add(item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return children;
    }

    private List<ItemDelegate> getChildren(SessionImpl session, String identifier, String login, Boolean showHidden) throws Exception {
        Node folderNode = session.getNodeByIdentifier(identifier);
        NodeIterator iterator = folderNode.getNodes();
        ArrayList<ItemDelegate> children = new ArrayList<ItemDelegate>();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            Boolean isHidden = false;
            if (node.hasProperty(NodeProperty.HIDDEN.toString())) {
                isHidden = node.getProperty(NodeProperty.HIDDEN.toString()).getBoolean();
            }
            String path = null;
            try {
                path = node.getPath();
                String name = path.substring(path.lastIndexOf(47) + 1);
                if (isHidden.booleanValue() && !showHidden.booleanValue() || name.equals("Trash") || name.equals("MySpecialFolders") || name.startsWith(REP_NAMESPACE) || name.startsWith(HL_NAMESPACE) || name.startsWith(".")) {
                    continue;
                }
            }
            catch (RepositoryException e1) {
                e1.printStackTrace();
            }
            ItemDelegate item = null;
            NodeManager wrap = new NodeManager(node, login);
            try {
                item = wrap.getItemDelegate();
                children.add(item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return children;
    }

    private ItemDelegate getDelegateItemById(SessionImpl session, String identifier, String login) throws Exception {
        Node node = session.getNodeByIdentifier(identifier);
        NodeManager wrap = new NodeManager(node, login);
        ItemDelegate item = null;
        try {
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    private ItemDelegate getDelegateItemByPath(SessionImpl session, String absPath, String login) throws Exception {
        Node node = session.getNode(absPath);
        NodeManager wrap = new NodeManager(node, login);
        return wrap.getItemDelegate();
    }

    private List<ItemDelegate> execute(SessionImpl session, String query, String lang, String login) throws Exception {
        LinkedList<ItemDelegate> list = null;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        try {
            Query q = null;
            if (lang.equals("JCR-SQL2")) {
                q = queryManager.createQuery(query, "JCR-SQL2");
            } else if (lang.equals("xpath")) {
                q = queryManager.createQuery(query, "xpath");
            } else if (lang.equals("sql")) {
                q = queryManager.createQuery(query, "sql");
            } else if (lang.equals("JCR_JQOM")) {
                q = queryManager.createQuery(query, "JCR-JQOM");
            } else {
                logger.error("lang unknown");
            }
            QueryResult result = q.execute();
            NodeIterator iterator = result.getNodes();
            list = new LinkedList<ItemDelegate>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node, login);
                if (itemName == null) {
                    logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                NodeManager wrap = new NodeManager(node, login);
                try {
                    ItemDelegate item = wrap.getItemDelegate();
                    list.add(item);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public String isValidSearchResult(Node node, String login) {
        String sharePath = "/Share";
        String userPath = "/Home/" + login;
        try {
            String nodePath = node.getPath();
            if (nodePath.startsWith(userPath)) {
                return node.getProperty(NodeProperty.TITLE.toString()).getString();
            }
            if (nodePath.startsWith(sharePath)) {
                Node sharedNode = (Node)node.getAncestor(2);
                if (node.getPath().equals(sharedNode.getPath())) {
                    Node usersNode = sharedNode.getNode(NodeProperty.USERS.toString());
                    String prop = usersNode.getProperty(login).getValue().getString();
                    String[] value = prop.split(PATH_SEPARATOR);
                    return value[1];
                }
                return node.getName();
            }
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    private ItemDelegate cloneItem(SessionImpl session, String srcAbsPath, String destAbsPath, boolean removeExisting, String login) {
        ItemDelegate item = null;
        try {
            session.getWorkspace().clone(session.getWorkspace().getName(), srcAbsPath, destAbsPath, removeExisting);
            Node node = session.getNode(destAbsPath);
            NodeManager wrap = new NodeManager(node, login);
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    private ItemDelegate copyItem(SessionImpl session, String srcAbsPath, String destAbsPath, String login) {
        ItemDelegate item = null;
        try {
            session.getWorkspace().copy(srcAbsPath, destAbsPath);
            Node node = session.getNode(destAbsPath);
            NodeManager wrap = new NodeManager(node, login);
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    private ItemDelegate createReference(SessionImpl session, String srcID, String destID, String login) {
        ItemDelegate item = null;
        Node srcNode = null;
        Node destNode = null;
        try {
            srcNode = session.getNodeByIdentifier(srcID);
            srcNode.addMixin("mix:referenceable");
            destNode = session.getNodeByIdentifier(destID);
            Node link = destNode.addNode(srcNode.getName(), srcNode.getPrimaryNodeType().getName());
            link.setProperty(NodeProperty.REFERENCE.toString(), srcNode);
            session.save();
            logger.info("References to " + srcNode.getPath() + ":");
            for (Property reference : JcrUtils.getReferences((Node)srcNode)) {
                logger.info("- " + reference.getPath());
            }
            NodeManager wrap = new NodeManager(link, login);
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    private ItemDelegate moveItem(SessionImpl session, String srcAbsPath, String destAbsPath, String login) throws RepositoryException, InternalErrorException {
        session.move(srcAbsPath, destAbsPath);
        session.save();
        NodeManager myNode = null;
        try {
            myNode = new NodeManager(session.getNode(destAbsPath), login);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myNode.getItemDelegate();
    }

    private ItemDelegate copyContetItem(SessionImpl session, String srcId, String destId, String login) throws Exception {
        Node nodeFolder = session.getNodeByIdentifier(destId);
        Node sharedNode = session.getNodeByIdentifier(srcId);
        ItemDelegate item = null;
        NodeIterator iterator = sharedNode.getNodes();
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            if (child.getName().startsWith(HL_NAMESPACE) || child.getName().startsWith(JCR_NAMESPACE) || child.getName().startsWith(REP_NAMESPACE)) continue;
            session.getWorkspace().copy(child.getPath(), nodeFolder.getPath() + PATH_SEPARATOR + child.getName());
        }
        NodeManager wrap = new NodeManager(nodeFolder, login);
        item = wrap.getItemDelegate();
        return item;
    }

    private void remove(SessionImpl session, String absPath) {
        try {
            session.removeItem(absPath);
            session.save();
        }
        catch (Exception e) {
            logger.error("impossible to remove item delegate: " + e);
        }
    }

    private List<SearchItemDelegate> execute(SessionImpl session, String query, String lang, String login, int limit) throws Exception {
        LinkedList<SearchItemDelegate> list = null;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        try {
            Query q = null;
            switch (lang) {
                case "JCR-SQL2": {
                    q = queryManager.createQuery(query, "JCR-SQL2");
                    break;
                }
                case "xpath": {
                    q = queryManager.createQuery(query, "xpath");
                    break;
                }
                case "sql": {
                    q = queryManager.createQuery(query, "sql");
                    break;
                }
                case "JCR_JQOM": {
                    q = queryManager.createQuery(query, "JCR-JQOM");
                    break;
                }
                default: {
                    logger.error("lang unknown");
                }
            }
            QueryResult result = q.execute();
            NodeIterator iterator = result.getNodes();
            list = new LinkedList<SearchItemDelegate>();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node, login);
                if (itemName == null) {
                    logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                SearchItemDelegate item = null;
                NodeManager wrap = new NodeManager(node, login);
                try {
                    item = wrap.getSearchItem(itemName);
                    if (list.contains(item)) continue;
                    list.add(item);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

