/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.ftp;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.ItemDelegateWrapper;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.apache.jackrabbit.j2ee.workspacemanager.storage.GCUBEStorage;
import org.apache.jackrabbit.j2ee.workspacemanager.util.MetaInfo;
import org.apache.jackrabbit.j2ee.workspacemanager.util.Util;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upload
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(Upload.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        String scope = request.getParameter("scope");
        String filenameWithExtension = request.getParameter("filename");
        String serviceName = request.getParameter("serviceName");
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        String parentPath = request.getParameter("parentPath");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(login, user, pass);
                sessionId = session.toString();
            }
            try {
                GCUBEStorage storage;
                String remotePath = parentPath + name;
                Node parent = session.getNode(parentPath);
                ServletInputStream inputStream = request.getInputStream();
                MetaInfo metadata = null;
                if (inputStream != null && (metadata = Util.getMetadataInfo((InputStream)inputStream, (GCUBEStorage)(storage = new GCUBEStorage(login, scope, serviceName)), (String)remotePath, (String)filenameWithExtension)).getStorageId() == null) {
                    throw new Exception("Inpustream not saved in storage.");
                }
                ItemDelegate delegate = new ItemDelegate();
                delegate.setName(name);
                delegate.setTitle(name);
                delegate.setDescription(description);
                delegate.setParentId(parent.getIdentifier());
                delegate.setOwner(login);
                delegate.setPrimaryType("nthl:externalImage");
                delegate.setLastAction(WorkspaceItemAction.CREATED);
                HashMap<NodeProperty, String> content = new HashMap<NodeProperty, String>();
                content.put(NodeProperty.CONTENT, ContentType.IMAGE.toString());
                content.put(NodeProperty.FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_IMAGE.toString());
                content.put(NodeProperty.PORTAL_LOGIN, login);
                content.put(NodeProperty.MIME_TYPE, metadata.getMimeType());
                Long size = Long.valueOf(String.valueOf(metadata.getSize()));
                content.put(NodeProperty.SIZE, new XStream().toXML((Object)size));
                content.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                delegate.setContent(content);
                ItemDelegateWrapper wrapper = new ItemDelegateWrapper(delegate, login);
                ItemDelegate new_item = wrapper.save((Session)session);
                xmlConfig = xstream.toXML((Object)new_item.getPath());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error saving inpustream for file: " + filenameWithExtension, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }
}

