/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListFolder
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(ListFolder.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(login, user, pass);
                sessionId = session.toString();
            }
            this.listFolder(request, response, out, xstream, session);
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private void listFolder(HttpServletRequest request, HttpServletResponse response, PrintWriter out, XStream xstream, SessionImpl session) {
        String folderPath = null;
        HashMap<String, Boolean> children = null;
        try {
            children = new HashMap<String, Boolean>();
            folderPath = request.getParameter("absPath");
            logger.info("Servlet ListFolder called with parameters: [folderPath: " + folderPath + "]");
            NodeIterator iterator = session.getNode(folderPath).getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                String path = null;
                try {
                    path = node.getPath();
                    String name = path.substring(path.lastIndexOf(47) + 1);
                    if (name.equals("Trash") || name.equals("MySpecialFolders") || name.startsWith("rep:") || name.startsWith("hl:") || name.startsWith(".")) {
                        continue;
                    }
                }
                catch (RepositoryException e1) {
                    e1.printStackTrace();
                }
                try {
                    Boolean flag = node.getPrimaryNodeType().getName().equals("nthl:workspaceItem");
                    children.put(node.getName(), flag);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String xmlConfig = xstream.toXML(children);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (Exception e) {
            logger.error("Error getting children for path: " + folderPath, (Throwable)e);
            String xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
    }
}

