/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.post;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyContent
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CopyContent.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(login, user, pass);
                sessionId = session.toString();
            }
            String srcAbsPath111 = null;
            String destAbsPath111 = null;
            try {
                srcAbsPath111 = new String(request.getParameter("srcAbsPath").getBytes("iso-8859-1"), "UTF-8");
                destAbsPath111 = new String(request.getParameter("destAbsPath").getBytes("iso-8859-1"), "UTF-8");
                logger.info("Servlet CopyContent called with parameters: [srcAbsPath11: " + srcAbsPath111 + " - destAbsPath11: " + destAbsPath111 + "]");
                ItemDelegate new_item = this.copyContetItem(session, srcAbsPath111, destAbsPath111, login);
                xmlConfig = xstream.toXML((Object)new_item);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error moving item from path: " + srcAbsPath111 + " - to: " + destAbsPath111, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error repository ex " + e.getMessage());
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private ItemDelegate copyContetItem(SessionImpl session, String srcId, String destId, String login) throws Exception {
        Node nodeFolder = session.getNodeByIdentifier(destId);
        Node sharedNode = session.getNodeByIdentifier(srcId);
        ItemDelegate item = null;
        NodeIterator iterator = sharedNode.getNodes();
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            if (child.getName().startsWith("hl:") || child.getName().startsWith("jcr:") || child.getName().startsWith("rep:")) continue;
            session.getWorkspace().copy(child.getPath(), nodeFolder.getPath() + "/" + child.getName());
        }
        NodeManager wrap = new NodeManager(nodeFolder, login);
        item = wrap.getItemDelegate();
        return item;
    }
}

