/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.workspacemanager.MySession;
import org.gcube.common.homelibary.model.util.MemoryCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private static MemoryCache<String, MySession> list;
    private static SessionManager sessionManager;
    private static Repository rep;
    private char[] pass = null;
    private String user = null;
    private static long timeToLiveInSeconds;
    private static long timerIntervalInSeconds;
    private static int maxItems;

    private SessionManager() {
        list = new MemoryCache(timeToLiveInSeconds, timerIntervalInSeconds, maxItems);
    }

    public static synchronized SessionManager getInstance(Repository repository) {
        rep = repository;
        if (sessionManager == null) {
            sessionManager = new SessionManager();
        }
        return sessionManager;
    }

    public synchronized SessionImpl getSession(String sessionId) {
        SessionImpl session = null;
        if (list.size() > 0) {
            session = ((MySession)list.get((Object)sessionId)).getSession();
        }
        return session;
    }

    public synchronized SessionImpl newSession(String login, String myUser, char[] myPass) {
        this.user = myUser;
        this.pass = myPass;
        SessionImpl session = null;
        try {
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(this.user, this.pass));
            list.put((Object)session.toString(), (Object)new MySession(login, session));
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
        }
        return session;
    }

    public synchronized void releaseSession(String id) {
        SessionImpl session = null;
        try {
            session = this.getSession(id);
            if (session != null) {
                session.logout();
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
        }
        list.remove((Object)id);
    }

    public boolean sessionExists(String uuid) {
        return list.containsKey((Object)uuid);
    }

    public Set<String> getSessionIds() {
        return list.keySet();
    }

    static {
        sessionManager = null;
        rep = null;
        timeToLiveInSeconds = 3600L;
        timerIntervalInSeconds = 7200L;
        maxItems = 20;
    }
}

