/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.ItemDelegateWrapper;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.apache.jackrabbit.j2ee.workspacemanager.accounting.AccountingDelegateWrapper;
import org.apache.jackrabbit.j2ee.workspacemanager.storage.GCUBEStorage;
import org.apache.jackrabbit.j2ee.workspacemanager.util.MetaInfo;
import org.apache.jackrabbit.j2ee.workspacemanager.util.Util;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostServlets
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(PostServlets.class);
    private static final long serialVersionUID = 1L;
    public static final String PATH_SEPARATOR = "/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    public static final String HL_NAMESPACE = "hl:";
    public static final String JCR_NAMESPACE = "jcr:";
    public static final String REP_NAMESPACE = "rep:";
    public static final String NT_WORKSPACE_FOLDER = "nthl:workspaceItem";
    public static final String NT_WORKSPACE_SHARED_FOLDER = "nthl:workspaceSharedItem";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            String servlet;
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(login, user, pass);
                sessionId = session.toString();
            }
            StringBuffer requestURL = request.getRequestURL();
            switch (servlet = requestURL.toString().substring(requestURL.lastIndexOf(PATH_SEPARATOR) + 1, requestURL.length())) {
                case "Upload": {
                    this.upload(request, response, out, xstream, session);
                    return;
                }
                case "UploadFile": {
                    this.uploadFile(request, response, out, xstream, session);
                    return;
                }
                case "CreateFolder": {
                    this.createFolder(request, response, out, xstream, session);
                    return;
                }
                case "Delete": {
                    this.delete(request, response, out, xstream, session);
                    return;
                }
                case "CopyContent": {
                    String srcAbsPath111 = null;
                    String destAbsPath111 = null;
                    try {
                        srcAbsPath111 = new String(request.getParameter("srcAbsPath").getBytes("iso-8859-1"), "UTF-8");
                        destAbsPath111 = new String(request.getParameter("destAbsPath").getBytes("iso-8859-1"), "UTF-8");
                        logger.info("Servlet CopyContent called with parameters: [srcAbsPath11: " + srcAbsPath111 + " - destAbsPath11: " + destAbsPath111 + "]");
                        ItemDelegate new_item = this.copyContetItem(session, srcAbsPath111, destAbsPath111, login);
                        xmlConfig = xstream.toXML((Object)new_item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error moving item from path: " + srcAbsPath111 + " - to: " + destAbsPath111, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "RemoveItem": {
                    String absPath = null;
                    try {
                        absPath = request.getParameter("absPath");
                        logger.info("Servlet RemoveItem called with parameters: [absPath: " + absPath + "]");
                        this.remove(session, absPath);
                        xmlConfig = xstream.toXML((Object)true);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error removing item by path: " + absPath, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)false);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "SaveItem": {
                    ItemDelegate item = null;
                    try {
                        item = (ItemDelegate)xstream.fromXML((InputStream)request.getInputStream());
                        logger.info("Servlet saveItem called on item: " + item.getName());
                        ItemDelegateWrapper wrapper = new ItemDelegateWrapper(item, "");
                        ItemDelegate new_item = wrapper.save((Session)session);
                        xmlConfig = xstream.toXML((Object)new_item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (LockException e) {
                        logger.error("Error saving item with id: " + item.getId(), (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error saving item with id: " + item.getId(), (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "AddNode": {
                    String parentId = null;
                    String id = null;
                    try {
                        parentId = request.getParameter("parentId");
                        id = request.getParameter("id");
                        logger.info("Servlet AddNode called with id: " + id + " to parentId " + parentId);
                        ItemDelegate new_item = this.addNodeToParent(session, parentId, id);
                        xmlConfig = xstream.toXML((Object)new_item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error adding item with id: " + id + " to parentId " + parentId, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "CreateReference": {
                    String srcID = null;
                    String destID = null;
                    String name = null;
                    try {
                        srcID = request.getParameter("srcId");
                        destID = request.getParameter("destId");
                        name = request.getParameter("name");
                        logger.info("Servlet CreateReference called with parameters: [srcID: " + srcID + " - destID: " + destID + "]");
                        ItemDelegate new_item = this.createReference(session, srcID, destID, name, login);
                        xmlConfig = xstream.toXML((Object)new_item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error creating reference of node id: " + srcID + " - to destination id: " + destID, (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "MoveToTrashIds": {
                    List itemIds = null;
                    String trashId = null;
                    try {
                        trashId = request.getParameter("trashId");
                        itemIds = (List)xstream.fromXML((InputStream)request.getInputStream());
                        logger.info("Remove " + itemIds.size() + " items");
                        Map error = this.moveToTrashIds(session, itemIds, trashId, login);
                        xmlConfig = xstream.toXML((Object)error);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error removing items", (Throwable)e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
                case "SaveAccountingItem": {
                    try {
                        AccountingDelegate item1 = (AccountingDelegate)xstream.fromXML((InputStream)request.getInputStream());
                        logger.info("Servlet SaveAccountingItem called for entry " + item1.getEntryType().toString());
                        AccountingDelegateWrapper wrapper = new AccountingDelegateWrapper(item1, "");
                        AccountingDelegate new_item = wrapper.save((Session)session);
                        xmlConfig = xstream.toXML((Object)new_item);
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                    catch (Exception e) {
                        logger.error("Error repository ex " + e);
                        xmlConfig = xstream.toXML((Object)e.toString());
                        response.setContentLength(xmlConfig.length());
                        out.println(xmlConfig);
                        return;
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error repository ex " + e.getMessage());
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
            return;
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private void delete(HttpServletRequest request, HttpServletResponse response, PrintWriter out, XStream xstream, SessionImpl session) {
        String path = null;
        Boolean flag = false;
        try {
            String scope = request.getParameter("scope");
            String serviceName = request.getParameter("serviceName");
            String portalLogin = request.getParameter("portalLogin");
            path = request.getParameter("absPath");
            Node node = session.getNode(path);
            Boolean isFolder = node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) || node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER);
            session.removeItem(path);
            session.save();
            GCUBEStorage storage = new GCUBEStorage(portalLogin, scope, serviceName);
            if (isFolder.booleanValue()) {
                storage.removeRemoteFolder(path);
            } else {
                storage.removeRemoteFile(path);
            }
            flag = true;
            String xmlConfig = xstream.toXML((Object)flag);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (Exception e) {
            logger.error("Error deleting item: " + path, (Throwable)e);
            String xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
    }

    private void createFolder(HttpServletRequest request, HttpServletResponse response, PrintWriter out, XStream xstream, SessionImpl session) {
        String filenameWithExtension = null;
        try {
            String portalLogin = request.getParameter("portalLogin");
            String name = request.getParameter("name");
            String description = request.getParameter("description");
            String parentPath = request.getParameter("parentPath");
            Node parent = session.getNode(parentPath);
            ItemDelegate delegate = new ItemDelegate();
            delegate.setName(name);
            delegate.setTitle(name);
            delegate.setDescription(description);
            delegate.setParentId(parent.getIdentifier());
            delegate.setOwner(portalLogin);
            delegate.setPrimaryType(NT_WORKSPACE_FOLDER);
            delegate.setLastAction(WorkspaceItemAction.CREATED);
            ItemDelegateWrapper wrapper = new ItemDelegateWrapper(delegate, portalLogin);
            ItemDelegate new_item = wrapper.save((Session)session);
            String xmlConfig = xstream.toXML((Object)new_item.getPath());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (Exception e) {
            logger.error("Error saving inpustream for file: " + filenameWithExtension, (Throwable)e);
            String xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
    }

    private void uploadFile(HttpServletRequest request, HttpServletResponse response, PrintWriter out, XStream xstream, SessionImpl session) {
        String filenameWithExtension = null;
        try {
            String portalLogin = request.getParameter("portalLogin");
            String scope = request.getParameter("scope");
            filenameWithExtension = request.getParameter("filename");
            String serviceName = request.getParameter("serviceName");
            String name = request.getParameter("name");
            String description = request.getParameter("description");
            String parentPath = request.getParameter("parentPath");
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (isMultipart) {
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iter = upload.getItemIterator(request);
                while (iter.hasNext()) {
                    GCUBEStorage storage;
                    FileItemStream item = iter.next();
                    String filename = item.getFieldName();
                    InputStream inputStream = item.openStream();
                    if (item.isFormField()) continue;
                    logger.info("** Upload File: field " + filename + " with file name " + item.getName() + " detected.");
                    String remotePath = parentPath + name;
                    Node parent = session.getNode(parentPath);
                    MetaInfo metadata = null;
                    if (inputStream != null && (metadata = Util.getMetadataInfo((InputStream)inputStream, (GCUBEStorage)(storage = new GCUBEStorage(portalLogin, scope, serviceName)), (String)remotePath, (String)filenameWithExtension)).getStorageId() == null) {
                        throw new Exception("Inpustream not saved in storage.");
                    }
                    ItemDelegate delegate = new ItemDelegate();
                    delegate.setName(name);
                    delegate.setTitle(name);
                    delegate.setDescription(description);
                    delegate.setParentId(parent.getIdentifier());
                    delegate.setOwner(portalLogin);
                    delegate.setPrimaryType("nthl:externalImage");
                    delegate.setLastAction(WorkspaceItemAction.CREATED);
                    HashMap<NodeProperty, String> content = new HashMap<NodeProperty, String>();
                    content.put(NodeProperty.CONTENT, ContentType.IMAGE.toString());
                    content.put(NodeProperty.FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_IMAGE.toString());
                    content.put(NodeProperty.PORTAL_LOGIN, portalLogin);
                    content.put(NodeProperty.MIME_TYPE, metadata.getMimeType());
                    Long l = Long.valueOf(String.valueOf(metadata.getSize()));
                    content.put(NodeProperty.SIZE, new XStream().toXML((Object)l));
                    content.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                    delegate.setContent(content);
                    ItemDelegateWrapper wrapper = new ItemDelegateWrapper(delegate, portalLogin);
                    ItemDelegate new_item = wrapper.save((Session)session);
                    String xmlConfig = xstream.toXML((Object)new_item.getPath());
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error saving inpustream for file: " + filenameWithExtension, (Throwable)e);
            String xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
    }

    private void upload(HttpServletRequest request, HttpServletResponse response, PrintWriter out, XStream xstream, SessionImpl session) {
        long start = System.currentTimeMillis();
        String filenameWithExtension = null;
        try {
            long size;
            String portalLogin = request.getParameter("portalLogin");
            String scope = request.getParameter("scope");
            filenameWithExtension = request.getParameter("filename");
            String serviceName = request.getParameter("serviceName");
            String name = request.getParameter("name");
            String description = request.getParameter("description");
            String parentPath = request.getParameter("parentPath");
            String remotePath = parentPath + name;
            Node parent = session.getNode(parentPath);
            ServletInputStream inputStream = request.getInputStream();
            String url = null;
            try {
                GCUBEStorage storage = new GCUBEStorage(portalLogin, scope, serviceName);
                long start1 = System.currentTimeMillis();
                url = storage.putStream((InputStream)inputStream, remotePath);
                logger.info(remotePath + " save in storage in " + (System.currentTimeMillis() - start1) + " millis");
                logger.info("saved to " + remotePath + " - GCUBEStorage URL : " + url);
                size = storage.getRemoteFileSize(remotePath);
            }
            catch (RemoteBackendException e) {
                logger.error(remotePath + " remote path not present" + (Object)((Object)e));
                throw new RemoteBackendException(e.getMessage());
            }
            ItemDelegate delegate = new ItemDelegate();
            delegate.setName(name);
            delegate.setTitle(name);
            delegate.setDescription(description);
            delegate.setParentId(parent.getIdentifier());
            delegate.setOwner(portalLogin);
            delegate.setPrimaryType("nthl:externalImage");
            delegate.setLastAction(WorkspaceItemAction.CREATED);
            HashMap<NodeProperty, String> content = new HashMap<NodeProperty, String>();
            content.put(NodeProperty.CONTENT, ContentType.IMAGE.toString());
            content.put(NodeProperty.FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_IMAGE.toString());
            content.put(NodeProperty.PORTAL_LOGIN, portalLogin);
            content.put(NodeProperty.MIME_TYPE, "image/jpeg");
            content.put(NodeProperty.SIZE, new XStream().toXML((Object)size));
            content.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
            delegate.setContent(content);
            ItemDelegateWrapper wrapper = new ItemDelegateWrapper(delegate, portalLogin);
            ItemDelegate new_item = wrapper.save((Session)session);
            String xmlConfig = xstream.toXML((Object)new_item.getPath());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
            logger.info(remotePath + " save in storage and jackrabbit in " + (System.currentTimeMillis() - start) + " millis");
        }
        catch (Exception e) {
            logger.error("Error saving inpustream for file: " + filenameWithExtension, (Throwable)e);
            String xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
    }

    private ItemDelegate addNodeToParent(SessionImpl session, String parentId, String id) {
        ItemDelegate item = null;
        try {
            Node parent = session.getNodeByIdentifier(parentId);
            Node node = parent.addNode(id);
            NodeManager wrap = new NodeManager(node, "");
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            logger.error("impossible to add item " + id + " to parentId " + parentId, (Object)e.getMessage());
        }
        return item;
    }

    private Map<String, String> moveToTrashIds(SessionImpl session, List<String> itemIds, String trashId, String login) throws ItemNotFoundException, RepositoryException {
        Node trash = session.getNodeByIdentifier(trashId);
        HashMap<String, String> errors = new HashMap<String, String>();
        for (String id : itemIds) {
            Node node = null;
            try {
                node = session.getNodeByIdentifier(id);
                Node trashItem = trash.addNode(id, "nthl:trashItem");
                trashItem.setProperty(NodeProperty.LAST_ACTION.toString(), WorkspaceItemAction.CREATED.toString());
                trashItem.setProperty(NodeProperty.PORTAL_LOGIN.toString(), login);
                trashItem.setProperty(NodeProperty.TITLE.toString(), id);
                trashItem.setProperty(NodeProperty.DESCRIPTION.toString(), "trash item of node " + node.getPath());
                trashItem.setProperty(NodeProperty.TRASH_ITEM_NAME.toString(), node.getName());
                trashItem.setProperty(NodeProperty.DELETE_DATE.toString(), Calendar.getInstance());
                trashItem.setProperty(NodeProperty.DELETE_BY.toString(), login);
                trashItem.setProperty(NodeProperty.DELETED_FROM.toString(), node.getParent().getPath());
                trashItem.setProperty(NodeProperty.ORIGINAL_PARENT_ID.toString(), node.getParent().getIdentifier());
                try {
                    Node contentNode = node.getNode(NodeProperty.CONTENT.toString());
                    String mimeType = contentNode.getProperty(NodeProperty.MIME_TYPE.toString()).getString();
                    trashItem.setProperty(NodeProperty.TRASH_ITEM_MIME_TYPE.toString(), mimeType);
                    trashItem.setProperty(NodeProperty.IS_FOLDER.toString(), false);
                }
                catch (Exception e) {
                    logger.error("mimetype and lenght not in node " + node.getPath() + e);
                    trashItem.setProperty(NodeProperty.IS_FOLDER.toString(), true);
                }
                session.save();
                logger.info("Move item: " + node.getPath() + " to " + trashItem.getPath() + PATH_SEPARATOR + node.getName());
                session.move(node.getPath(), trashItem.getPath() + PATH_SEPARATOR + node.getName());
                session.save();
                Node myTrash = session.getNode(trashItem.getPath() + PATH_SEPARATOR + node.getName());
                logger.info("Update remote path of " + myTrash.getPath());
                this.updateRemotePath(myTrash);
            }
            catch (Exception e) {
                errors.put(id, e.toString());
                logger.error("impossible to move item " + node.getPath() + " to trash. " + e);
            }
        }
        return errors;
    }

    private void updateRemotePath(Node item) throws AccessDeniedException, ValueFormatException, VersionException, LockException, ConstraintViolationException, PathNotFoundException, ItemExistsException, ReferentialIntegrityException, InvalidItemStateException, NoSuchNodeTypeException, RepositoryException {
        if (item.hasNode(NodeProperty.CONTENT.toString())) {
            Node contentNode = item.getNode(NodeProperty.CONTENT.toString());
            if (contentNode.hasProperty(NodeProperty.REMOTE_STORAGE_PATH.toString())) {
                contentNode.setProperty(NodeProperty.REMOTE_STORAGE_PATH.toString(), item.getPath());
                item.getSession().save();
            }
        } else {
            NodeIterator iterator = item.getNodes();
            while (iterator.hasNext()) {
                Node child = iterator.nextNode();
                this.updateRemotePath(child);
            }
        }
    }

    private List<ItemDelegate> getChildren(SessionImpl session, String identifier, String login) throws Exception {
        Node folderNode = session.getNodeByIdentifier(identifier);
        NodeIterator iterator = folderNode.getNodes();
        ArrayList<ItemDelegate> children = new ArrayList<ItemDelegate>();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            String path = null;
            try {
                path = node.getPath();
                String name = path.substring(path.lastIndexOf(47) + 1);
                if (name.equals("Trash") || name.equals("MySpecialFolders") || name.startsWith(REP_NAMESPACE) || name.startsWith(HL_NAMESPACE) || name.startsWith(".")) {
                    continue;
                }
            }
            catch (RepositoryException e1) {
                e1.printStackTrace();
            }
            ItemDelegate item = null;
            NodeManager wrap = new NodeManager(node, login);
            try {
                item = wrap.getItemDelegate();
                children.add(item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return children;
    }

    private ItemDelegate getDelegateItemById(SessionImpl session, String identifier, String login) throws Exception {
        Node node = session.getNodeByIdentifier(identifier);
        NodeManager wrap = new NodeManager(node, login);
        ItemDelegate item = null;
        try {
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    private ItemDelegate getDelegateItemByPath(SessionImpl session, String absPath, String login) throws Exception {
        Node node = session.getNode(absPath);
        NodeManager wrap = new NodeManager(node, login);
        return wrap.getItemDelegate();
    }

    private List<ItemDelegate> execute(SessionImpl session, String query, String lang, String login) throws Exception {
        LinkedList<ItemDelegate> list = null;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        try {
            Query q = null;
            if (lang.equals("JCR-SQL2")) {
                q = queryManager.createQuery(query, "JCR-SQL2");
            } else if (lang.equals("xpath")) {
                q = queryManager.createQuery(query, "xpath");
            } else if (lang.equals("sql")) {
                q = queryManager.createQuery(query, "sql");
            } else if (lang.equals("JCR_JQOM")) {
                q = queryManager.createQuery(query, "JCR-JQOM");
            } else {
                logger.error("lang unknown");
            }
            QueryResult result = q.execute();
            NodeIterator iterator = result.getNodes();
            list = new LinkedList<ItemDelegate>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node, login);
                if (itemName == null) {
                    logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                NodeManager wrap = new NodeManager(node, login);
                try {
                    ItemDelegate item = wrap.getItemDelegate();
                    list.add(item);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public String isValidSearchResult(Node node, String login) {
        String sharePath = "/Share";
        String userPath = "/Home/" + login;
        try {
            String nodePath = node.getPath();
            if (nodePath.startsWith(userPath)) {
                return node.getProperty(NodeProperty.TITLE.toString()).getString();
            }
            if (nodePath.startsWith(sharePath)) {
                Node sharedNode = (Node)node.getAncestor(2);
                if (node.getPath().equals(sharedNode.getPath())) {
                    Node usersNode = sharedNode.getNode(NodeProperty.USERS.toString());
                    String prop = usersNode.getProperty(login).getValue().getString();
                    String[] value = prop.split(PATH_SEPARATOR);
                    return value[1];
                }
                return node.getName();
            }
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    private ItemDelegate cloneItem(SessionImpl session, String srcAbsPath, String destAbsPath, boolean removeExisting, String login) {
        ItemDelegate item = null;
        try {
            session.getWorkspace().clone(session.getWorkspace().getName(), srcAbsPath, destAbsPath, removeExisting);
            Node node = session.getNode(destAbsPath);
            NodeManager wrap = new NodeManager(node, login);
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    private ItemDelegate copyItem(SessionImpl session, String srcAbsPath, String destAbsPath, String login) {
        ItemDelegate item = null;
        try {
            session.getWorkspace().copy(srcAbsPath, destAbsPath);
            Node node = session.getNode(destAbsPath);
            NodeManager wrap = new NodeManager(node, login);
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    private ItemDelegate createReference(SessionImpl session, String srcID, String destID, String name, String login) {
        ItemDelegate item = null;
        Node srcNode = null;
        Node destNode = null;
        try {
            srcNode = session.getNodeByIdentifier(srcID);
            srcNode.addMixin("mix:referenceable");
            destNode = session.getNodeByIdentifier(destID);
            Node link = destNode.addNode(name, "nthl:workspaceReference");
            link.setProperty(NodeProperty.REFERENCE.toString(), srcNode);
            link.setProperty(NodeProperty.PORTAL_LOGIN.toString(), login);
            link.setProperty(NodeProperty.TITLE.toString(), srcNode.getName());
            link.setProperty(NodeProperty.LAST_ACTION.toString(), WorkspaceItemAction.CREATED.toString());
            session.save();
            logger.info("References to " + srcNode.getPath() + ":");
            for (Property reference : JcrUtils.getReferences((Node)srcNode)) {
                logger.info("- " + reference.getPath().replace(NodeProperty.REFERENCE.toString(), ""));
            }
            NodeManager wrap = new NodeManager(link, login);
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    private ItemDelegate moveItem(SessionImpl session, String srcAbsPath, String destAbsPath, String login) throws RepositoryException {
        session.move(srcAbsPath, destAbsPath);
        session.save();
        NodeManager myNode = null;
        try {
            myNode = new NodeManager(session.getNode(destAbsPath), login);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myNode.getItemDelegate();
    }

    private ItemDelegate copyContetItem(SessionImpl session, String srcId, String destId, String login) throws Exception {
        Node nodeFolder = session.getNodeByIdentifier(destId);
        Node sharedNode = session.getNodeByIdentifier(srcId);
        ItemDelegate item = null;
        NodeIterator iterator = sharedNode.getNodes();
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            if (child.getName().startsWith(HL_NAMESPACE) || child.getName().startsWith(JCR_NAMESPACE) || child.getName().startsWith(REP_NAMESPACE)) continue;
            session.getWorkspace().copy(child.getPath(), nodeFolder.getPath() + PATH_SEPARATOR + child.getName());
        }
        NodeManager wrap = new NodeManager(nodeFolder, login);
        item = wrap.getItemDelegate();
        return item;
    }

    private void remove(SessionImpl session, String absPath) {
        try {
            session.removeItem(absPath);
            session.save();
        }
        catch (Exception e) {
            logger.error("impossible to remove item delegate: " + e);
        }
    }
}

