/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetParentsById
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetParentsById.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(login, user, pass);
                sessionId = session.toString();
            }
            String id = null;
            try {
                id = request.getParameter("id");
                logger.info("Servlet GetParentsById called with parameters: [id: " + id + "]");
                List children = this.getParentsById(session, id, login);
                xmlConfig = xstream.toXML((Object)children);
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error getting parents by id: " + id, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }

    private List<ItemDelegate> getParentsById(SessionImpl session, String identifier, String login) throws Exception {
        Node node = session.getNodeByIdentifier(identifier);
        ArrayList<ItemDelegate> parents = new ArrayList<ItemDelegate>();
        while (!this.isRoot(node) && node != null) {
            ItemDelegate item = null;
            NodeManager wrap = new NodeManager(node, login);
            try {
                item = wrap.getItemDelegate();
                parents.add(item);
                if (login != null && item.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                    Map users = (Map)new XStream().fromXML((String)item.getProperties().get(NodeProperty.USERS));
                    String[] user = ((String)users.get(login)).split("/");
                    String parentId = user[0];
                    node = session.getNodeByIdentifier(parentId);
                    continue;
                }
                node = node.getParent();
            }
            catch (Exception e) {
                logger.error("Error getting parents by id " + e);
            }
        }
        return parents;
    }

    public boolean isRoot(Node node) throws RepositoryException {
        Node parent = null;
        try {
            parent = node.getParent();
        }
        catch (ItemNotFoundException e) {
            return true;
        }
        return parent == null;
    }
}

