/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.post;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.apache.jackrabbit.j2ee.workspacemanager.accounting.AccountingDelegateWrapper;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveAccountingItem
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(SaveAccountingItem.class);
    private static final long serialVersionUID = 1L;
    public static final String PATH_SEPARATOR = "/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    public static final String HL_NAMESPACE = "hl:";
    public static final String JCR_NAMESPACE = "jcr:";
    public static final String REP_NAMESPACE = "rep:";
    public static final String NT_WORKSPACE_FOLDER = "nthl:workspaceItem";
    public static final String NT_WORKSPACE_SHARED_FOLDER = "nthl:workspaceSharedItem";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(login, user, pass);
                sessionId = session.toString();
            }
            try {
                AccountingDelegate item1 = (AccountingDelegate)xstream.fromXML((InputStream)request.getInputStream());
                logger.info("Servlet SaveAccountingItem called for entry " + item1.getEntryType().toString());
                AccountingDelegateWrapper wrapper = new AccountingDelegateWrapper(item1, "");
                AccountingDelegate new_item = wrapper.save((Session)session);
                xmlConfig = xstream.toXML((Object)new_item);
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.toString());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error repository ex " + e.getMessage());
            xmlConfig = xstream.toXML((Object)e.toString());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }
}

