/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.accessmanager.privileges;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CanModifyProperties
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CanModifyProperties.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String absPath = new String(request.getParameter("absPath").getBytes("iso-8859-1"), "UTF-8");
        boolean isRoot = Boolean.valueOf(request.getParameter("isRoot"));
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(login);
                sessionId = session.toString();
            }
            try {
                Boolean flag = CanModifyProperties.canAddChildren((String)session.getUserID(), (String)absPath, (Boolean)isRoot, (Session)session);
                xmlConfig = xstream.toXML((Object)flag);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error checking ACL CanAddChildren of item: " + absPath, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    public static boolean canAddChildren(String login, String absPath, Boolean root, Session session) throws Exception {
        try {
            AccessControlManager accessControlManager = session.getAccessControlManager();
            boolean canDelete = false;
            canDelete = root != false ? accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties"), accessControlManager.privilegeFromName("hl:noOwnershipLimit"), accessControlManager.privilegeFromName("hl:removeSharedRoot")}) : accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties"), accessControlManager.privilegeFromName("hl:noOwnershipLimit")});
            return canDelete;
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

