/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.items.gcube;

import com.thoughtworks.xstream.XStream;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRDocument;
import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;

public class JCRImageDocument
extends JCRDocument {
    public JCRImageDocument(Node node, String login) throws RepositoryException {
        super(node, login);
        Node image = node.getNode(NodeProperty.CONTENT.toString());
        Map map = this.item.getProperties();
        map.put(NodeProperty.FOLDER_ITEM_TYPE, new XStream().toXML((Object)node.getProperty(NodeProperty.FOLDER_ITEM_TYPE.toString()).getString()));
        map.put(NodeProperty.CONTENT, new XStream().toXML((Object)ContentType.IMAGE));
        if (image.hasProperty(NodeProperty.IMAGE_WIDTH.toString())) {
            map.put(NodeProperty.IMAGE_WIDTH, new XStream().toXML((Object)image.getProperty(NodeProperty.IMAGE_WIDTH.toString()).getLong()));
        }
        if (image.hasProperty(NodeProperty.IMAGE_HEIGHT.toString())) {
            map.put(NodeProperty.IMAGE_HEIGHT, new XStream().toXML((Object)image.getProperty(NodeProperty.IMAGE_HEIGHT.toString()).getLong()));
        }
        if (image.hasProperty(NodeProperty.THUMBNAIL_WIDTH.toString())) {
            map.put(NodeProperty.THUMBNAIL_WIDTH, new XStream().toXML((Object)image.getProperty(NodeProperty.THUMBNAIL_WIDTH.toString()).getLong()));
        }
        if (image.hasProperty(NodeProperty.THUMBNAIL_HEIGHT.toString())) {
            map.put(NodeProperty.THUMBNAIL_HEIGHT, new XStream().toXML((Object)image.getProperty(NodeProperty.THUMBNAIL_HEIGHT.toString()).getLong()));
        }
        try {
            String remotePath = image.getProperty(NodeProperty.REMOTE_STORAGE_PATH.toString()).getString();
            map.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
        }
        catch (Exception remotePath) {
            // empty catch block
        }
        try {
            String size = image.getProperty(NodeProperty.SIZE.toString()).getString();
            map.put(NodeProperty.SIZE, size);
        }
        catch (Exception size) {
            // empty catch block
        }
        try {
            String mimeType = image.getProperty(NodeProperty.MIME_TYPE.toString()).getString();
            map.put(NodeProperty.MIME_TYPE, mimeType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.item.setProperties(map);
    }
}

