/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.accessmanager.AccessControlUtil;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class List
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(List.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String absPath = request.getParameter("absPath");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            String login = sessionManager.getLogin(sessionId);
            PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
            Principal principal = principalManager.getPrincipal(login);
            JackrabbitAccessControlManager jacm = (JackrabbitAccessControlManager)session.getAccessControlManager();
            HashSet<Principal> principals = new HashSet<Principal>();
            principals.add(principal);
            logger.info("Check if " + principal.getName() + " can read node " + absPath);
            boolean canRead = jacm.hasPrivileges(absPath, principals, new Privilege[]{jacm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")});
            logger.info("Can " + principal.getName() + " read node " + absPath + "? " + canRead);
            if (canRead) {
                this.listFolder(request, response, out, xstream, session, absPath);
            } else {
                xmlConfig = xstream.toXML((Object)"No privilege to read the folder");
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }

    private void listFolder(HttpServletRequest request, HttpServletResponse response, PrintWriter out, XStream xstream, Session session, String folderPath) {
        HashMap<String, Boolean> children = null;
        try {
            children = new HashMap<String, Boolean>();
            logger.info("Servlet ListFolder called with parameters: [folderPath: " + folderPath + "]");
            NodeIterator iterator = session.getNode(folderPath).getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                String path = null;
                try {
                    path = node.getPath();
                    String name = path.substring(path.lastIndexOf(47) + 1);
                    if (name.equals("Trash") || name.equals("MySpecialFolders") || name.startsWith("rep:") || name.startsWith("hl:") || name.startsWith(".")) {
                        continue;
                    }
                }
                catch (RepositoryException e1) {
                    e1.printStackTrace();
                }
                try {
                    Boolean flag = node.getPrimaryNodeType().getName().equals("nthl:workspaceItem");
                    children.put(node.getName(), flag);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String xmlConfig = xstream.toXML(children);
            out.println(xmlConfig);
        }
        catch (Exception e) {
            logger.error("Error getting children for path: " + folderPath, (Throwable)e);
            String xmlConfig = xstream.toXML((Object)e.toString());
            out.println(xmlConfig);
        }
    }
}

