/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.ItemDelegateWrapper;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.apache.jackrabbit.j2ee.workspacemanager.storage.GCUBEStorage;
import org.apache.jackrabbit.j2ee.workspacemanager.util.MetaInfo;
import org.apache.jackrabbit.j2ee.workspacemanager.util.Util;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadFile
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(UploadFile.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            this.uploadFile(request, response, out, xstream, session);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error repository ex " + e.getMessage());
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private void uploadFile(HttpServletRequest request, HttpServletResponse response, PrintWriter out, XStream xstream, Session session) {
        String filenameWithExtension = null;
        try {
            String portalLogin = request.getParameter("login");
            String scope = request.getParameter("scope");
            filenameWithExtension = request.getParameter("filename");
            String serviceName = request.getParameter("serviceName");
            String name = request.getParameter("name");
            String description = request.getParameter("description");
            String parentPath = request.getParameter("parentPath");
            String mimetype = request.getParameter("mimetype");
            String size = request.getParameter("size");
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (isMultipart) {
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iter = upload.getItemIterator(request);
                while (iter.hasNext()) {
                    GCUBEStorage storage;
                    FileItemStream item = iter.next();
                    String filename = item.getFieldName();
                    InputStream inputStream = item.openStream();
                    if (item.isFormField()) continue;
                    logger.info("** Upload File: field " + filename + " with file name " + item.getName() + " detected.");
                    String remotePath = parentPath + name;
                    Node parent = session.getNode(parentPath);
                    MetaInfo metadata = null;
                    if (inputStream != null && (metadata = Util.getMetadataInfo((InputStream)inputStream, (GCUBEStorage)(storage = new GCUBEStorage(portalLogin)), (String)remotePath, (String)filenameWithExtension, (String)mimetype, (long)Long.parseLong(size))).getStorageId() == null) {
                        throw new Exception("Inpustream not saved in storage.");
                    }
                    ItemDelegate delegate = new ItemDelegate();
                    delegate.setName(name);
                    delegate.setTitle(name);
                    delegate.setDescription(description);
                    delegate.setParentId(parent.getIdentifier());
                    delegate.setOwner(portalLogin);
                    delegate.setPrimaryType("nthl:externalImage");
                    delegate.setLastAction(WorkspaceItemAction.CREATED);
                    HashMap<NodeProperty, String> content = new HashMap<NodeProperty, String>();
                    content.put(NodeProperty.CONTENT, ContentType.IMAGE.toString());
                    content.put(NodeProperty.FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_IMAGE.toString());
                    content.put(NodeProperty.PORTAL_LOGIN, portalLogin);
                    content.put(NodeProperty.MIME_TYPE, metadata.getMimeType());
                    Long l = Long.valueOf(String.valueOf(metadata.getSize()));
                    content.put(NodeProperty.SIZE, new XStream().toXML((Object)l));
                    content.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                    delegate.setContent(content);
                    ItemDelegateWrapper wrapper = new ItemDelegateWrapper(delegate, portalLogin);
                    ItemDelegate new_item = wrapper.save(session);
                    String xmlConfig = xstream.toXML((Object)new_item.getPath());
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error saving inpustream for file: " + filenameWithExtension, (Throwable)e);
            String xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
    }
}

