/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetHiddenItemsById
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetHiddenItemsById.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            String id = null;
            try {
                id = request.getParameter("id");
                logger.info("Servlet GetHiddenItemsById called with parameters: [id: " + id + "]");
                List children = this.getHiddenItems(session, id, sessionManager.getLogin(request));
                xmlConfig = xstream.toXML((Object)children);
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error getting hidden items by id: " + id, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }

    private List<ItemDelegate> getHiddenItems(Session session, String identifier, String login) throws Exception {
        Node folderNode = session.getNodeByIdentifier(identifier);
        NodeIterator iterator = folderNode.getNodes();
        ArrayList<ItemDelegate> children = new ArrayList<ItemDelegate>();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            Boolean isHidden = false;
            if (node.hasProperty(NodeProperty.HIDDEN.toString())) {
                isHidden = node.getProperty(NodeProperty.HIDDEN.toString()).getBoolean();
            }
            if (!isHidden.booleanValue()) continue;
            ItemDelegate item = null;
            NodeManager wrap = new NodeManager(node, login);
            try {
                item = wrap.getItemDelegate();
                children.add(item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return children;
    }
}

