/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetItemByPath
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetItemByPath.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            String path = null;
            try {
                path = new String(request.getParameter("path").getBytes("iso-8859-1"), "UTF-8");
                logger.info("Servlet GetItemByPath called with parameters: [path: " + path + "]");
                ItemDelegate item = this.getDelegateItemByPath(session, path, sessionManager.getLogin(request));
                xmlConfig = xstream.toXML((Object)item);
                out.println(xmlConfig);
            }
            catch (PathNotFoundException e) {
                logger.error("PathNotFoundException: " + path);
                xmlConfig = xstream.toXML((Object)(path + " Path Not Found"));
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }

    private ItemDelegate getDelegateItemByPath(Session session, String absPath, String login) throws Exception {
        Node node = session.getNode(absPath);
        NodeManager wrap = new NodeManager(node, login);
        return wrap.getItemDelegate();
    }
}

