/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.post;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveToTrashIds
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(MoveToTrashIds.class);
    private static final long serialVersionUID = 1L;
    public static final String PATH_SEPARATOR = "/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    public static final String HL_NAMESPACE = "hl:";
    public static final String JCR_NAMESPACE = "jcr:";
    public static final String REP_NAMESPACE = "rep:";
    public static final String NT_WORKSPACE_FOLDER = "nthl:workspaceItem";
    public static final String NT_WORKSPACE_SHARED_FOLDER = "nthl:workspaceSharedItem";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            List itemIds = null;
            String trashId = null;
            try {
                trashId = request.getParameter("trashId");
                logger.info("Servlet MoveToTrashIds called with parameters: [trashId: " + trashId + " - by: " + sessionManager.getLogin(request) + "]");
                itemIds = (List)xstream.fromXML((InputStream)request.getInputStream());
                logger.info("Remove " + itemIds.size() + " items");
                Map error = this.moveToTrashIds(session, itemIds, trashId, sessionManager.getLogin(request));
                xmlConfig = xstream.toXML((Object)error);
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error removing items", (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error repository ex " + e.getMessage());
            xmlConfig = xstream.toXML((Object)e.toString());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }

    private Map<String, String> moveToTrashIds(Session session, List<String> itemIds, String trashId, String login) throws ItemNotFoundException, RepositoryException {
        Node trash = session.getNodeByIdentifier(trashId);
        HashMap<String, String> errors = new HashMap<String, String>();
        for (String id : itemIds) {
            Node node = null;
            try {
                node = session.getNodeByIdentifier(id);
                Node trashItem = trash.addNode(id, "nthl:trashItem");
                trashItem.setProperty(NodeProperty.LAST_ACTION.toString(), WorkspaceItemAction.CREATED.toString());
                trashItem.setProperty(NodeProperty.PORTAL_LOGIN.toString(), login);
                trashItem.setProperty(NodeProperty.TITLE.toString(), id);
                trashItem.setProperty(NodeProperty.DESCRIPTION.toString(), "trash item of node " + node.getPath());
                trashItem.setProperty(NodeProperty.TRASH_ITEM_NAME.toString(), node.getName());
                trashItem.setProperty(NodeProperty.DELETE_DATE.toString(), Calendar.getInstance());
                trashItem.setProperty(NodeProperty.DELETE_BY.toString(), login);
                trashItem.setProperty(NodeProperty.DELETED_FROM.toString(), node.getParent().getPath());
                trashItem.setProperty(NodeProperty.ORIGINAL_PARENT_ID.toString(), node.getParent().getIdentifier());
                try {
                    Node contentNode = node.getNode(NodeProperty.CONTENT.toString());
                    String mimeType = contentNode.getProperty(NodeProperty.MIME_TYPE.toString()).getString();
                    trashItem.setProperty(NodeProperty.TRASH_ITEM_MIME_TYPE.toString(), mimeType);
                    trashItem.setProperty(NodeProperty.IS_FOLDER.toString(), false);
                }
                catch (Exception e) {
                    logger.error("mimetype and lenght not in node " + node.getPath() + e);
                    trashItem.setProperty(NodeProperty.IS_FOLDER.toString(), true);
                }
                session.save();
                logger.info("Move item: " + node.getPath() + " to " + trashItem.getPath() + PATH_SEPARATOR + node.getName());
                session.move(node.getPath(), trashItem.getPath() + PATH_SEPARATOR + node.getName());
                session.save();
                Node myTrash = session.getNode(trashItem.getPath() + PATH_SEPARATOR + node.getName());
                logger.info("Update remote path of " + myTrash.getPath());
                this.updateRemotePath(myTrash);
            }
            catch (Exception e) {
                errors.put(id, e.toString());
                logger.error("impossible to move item " + node.getPath() + " to trash. " + e);
            }
        }
        return errors;
    }

    private void updateRemotePath(Node item) throws AccessDeniedException, ValueFormatException, VersionException, LockException, ConstraintViolationException, PathNotFoundException, ItemExistsException, ReferentialIntegrityException, InvalidItemStateException, NoSuchNodeTypeException, RepositoryException {
        if (item.hasNode(NodeProperty.CONTENT.toString())) {
            Node contentNode = item.getNode(NodeProperty.CONTENT.toString());
            if (contentNode.hasProperty(NodeProperty.REMOTE_STORAGE_PATH.toString())) {
                contentNode.setProperty(NodeProperty.REMOTE_STORAGE_PATH.toString(), item.getPath());
                item.getSession().save();
            }
        } else {
            NodeIterator iterator = item.getNodes();
            while (iterator.hasNext()) {
                Node child = iterator.nextNode();
                this.updateRemotePath(child);
            }
        }
    }
}

