/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.accessmanager.AccessControlUtil;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.apache.jackrabbit.j2ee.workspacemanager.storage.GCUBEStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Delete
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(Delete.class);
    private static final long serialVersionUID = 1L;
    private static final String PORTAL_LOGIN = "hl:portalLogin";
    private static final String OWNER_NODE = "hl:owner";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String path = request.getParameter("absPath");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            boolean canDelete = false;
            Boolean flag = false;
            try {
                String login = sessionManager.getLogin(sessionId);
                Node node = session.getNode(path);
                String owner = null;
                if (node.hasProperty(PORTAL_LOGIN)) {
                    owner = node.getProperty(PORTAL_LOGIN).getString();
                } else if (node.hasNode(OWNER_NODE)) {
                    owner = node.getNode(OWNER_NODE).getProperty(PORTAL_LOGIN).getString();
                }
                if (owner.equals(login)) {
                    canDelete = true;
                } else {
                    PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
                    Principal principal = principalManager.getPrincipal(login);
                    JackrabbitAccessControlManager jacm = (JackrabbitAccessControlManager)session.getAccessControlManager();
                    HashSet<Principal> principals = new HashSet<Principal>();
                    principals.add(principal);
                    logger.info("Check if " + principal.getName() + " can delete node " + path);
                    canDelete = jacm.hasPrivileges(path, principals, new Privilege[]{jacm.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes"), jacm.privilegeFromName("hl:noOwnershipLimit")});
                    logger.info("Can " + principal.getName() + " delete node " + path + "? " + canDelete);
                }
                if (canDelete) {
                    Boolean isFolder = node.getPrimaryNodeType().getName().equals("nthl:workspaceItem") || node.getPrimaryNodeType().getName().equals("nthl:workspaceSharedItem");
                    session.removeItem(path);
                    session.save();
                    GCUBEStorage storage = new GCUBEStorage(sessionManager.getLogin(request));
                    if (isFolder.booleanValue()) {
                        storage.removeRemoteFolder(path);
                    } else {
                        storage.removeRemoteFile(path);
                    }
                    flag = true;
                    xmlConfig = xstream.toXML((Object)flag);
                } else {
                    xmlConfig = xstream.toXML((Object)"No privilege to Delete node");
                }
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error deleting item: " + path, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }
}

