/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest.Utils;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upload
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(Upload.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long start = System.currentTimeMillis();
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String filenameWithExtension = request.getParameter("filename");
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        String parentPath = request.getParameter("parentPath");
        String mimetype = request.getParameter("mimetype");
        String size = request.getParameter("size");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            try {
                Workspace workspace = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
                parentPath = Utils.cleanPath((Workspace)workspace, (String)parentPath);
                WorkspaceFolder destinationFolder = (WorkspaceFolder)workspace.getItemByPath(parentPath);
                ServletInputStream inputStream = request.getInputStream();
                FolderItem folderItem = mimetype != null && size != null ? WorkspaceUtil.createExternalFile((WorkspaceFolder)destinationFolder, (String)name, (String)description, (InputStream)inputStream, new HashMap(), (String)mimetype, (long)Long.parseLong(size)) : (mimetype != null ? WorkspaceUtil.createExternalFile((WorkspaceFolder)destinationFolder, (String)name, (String)description, (String)mimetype, (InputStream)inputStream) : WorkspaceUtil.createExternalFile((WorkspaceFolder)destinationFolder, (String)name, (String)description, (InputStream)inputStream));
                xmlConfig = xstream.toXML((Object)folderItem.getPath());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error saving inpustream for file: " + filenameWithExtension, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
            logger.info("**** " + filenameWithExtension + " save in storage and jackrabbit in " + (System.currentTimeMillis() - start) + " millis");
        }
    }
}

