/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest.Utils;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upload
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(Upload.class);
    private static final long serialVersionUID = 1L;
    private static final String DATA = "data";
    private String name;
    private String description;
    private String parentPath;
    private String mimetype;
    private String size;
    private String filenameWithExtension;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long start = System.currentTimeMillis();
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        this.filenameWithExtension = request.getParameter("filename");
        this.name = request.getParameter("name");
        this.description = request.getParameter("description");
        this.parentPath = request.getParameter("parentPath");
        this.mimetype = request.getParameter("mimetype");
        this.size = request.getParameter("size");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            try {
                Object inputStream = request.getInputStream();
                logger.info("Get Inpustream: " + inputStream.available());
                try {
                    List multiparts = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(request);
                    for (FileItem item : multiparts) {
                        if (!item.isFormField()) {
                            if (!item.getFieldName().equals(DATA)) continue;
                            inputStream = item.getInputStream();
                            continue;
                        }
                        String field = item.getFieldName();
                        String value = item.getString();
                        switch (field) {
                            case "filename": {
                                this.filenameWithExtension = value;
                                break;
                            }
                            case "name": {
                                this.name = value;
                                break;
                            }
                            case "description": {
                                this.description = value;
                                break;
                            }
                            case "parentPath": {
                                this.parentPath = value;
                                break;
                            }
                            case "mimetype": {
                                this.mimetype = value;
                                break;
                            }
                            case "size": {
                                this.size = value;
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.info("No multipart boundary was found");
                }
                logger.info("Called Rest Servlet Upload with parameters:");
                logger.info("Session Id: " + sessionId);
                logger.info("filenameWithExtension: " + this.filenameWithExtension);
                logger.info("name: " + this.name);
                logger.info("description: " + this.description);
                logger.info("parentPath: " + this.parentPath);
                logger.info("mimetype: " + this.mimetype);
                logger.info("size: " + this.size);
                Workspace workspace = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
                this.parentPath = Utils.cleanPath((Workspace)workspace, (String)this.parentPath);
                WorkspaceFolder destinationFolder = (WorkspaceFolder)workspace.getItemByPath(this.parentPath);
                FolderItem folderItem = this.mimetype != null && this.size != null ? WorkspaceUtil.createExternalFile((WorkspaceFolder)destinationFolder, (String)this.name, (String)this.description, (InputStream)inputStream, new HashMap(), (String)this.mimetype, (long)Long.parseLong(this.size)) : (this.mimetype != null ? WorkspaceUtil.createExternalFile((WorkspaceFolder)destinationFolder, (String)this.name, (String)this.description, (String)this.mimetype, (InputStream)inputStream) : WorkspaceUtil.createExternalFile((WorkspaceFolder)destinationFolder, (String)this.name, (String)this.description, (InputStream)inputStream));
                xmlConfig = xstream.toXML((Object)folderItem.getPath());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error saving inpustream for file: " + this.filenameWithExtension, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
            logger.info("**** " + this.filenameWithExtension + " save in storage and jackrabbit in " + (System.currentTimeMillis() - start) + " millis");
        }
    }
}

