/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.accessmanager.privileges;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.acl.JCRAccessControlManager;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanReadNode
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CanReadNode.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String id = null;
        try {
            id = request.getParameter("id");
        }
        catch (Exception e) {
            logger.info("CanModifyProperties servlet - ID path not set ");
        }
        String absPath = null;
        try {
            absPath = new String(request.getParameter("absPath").getBytes("iso-8859-1"), "UTF-8");
        }
        catch (Exception e) {
            logger.info("CanReadNode servlet - ABS path not set ");
        }
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        String sessionId = null;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            session = sessionManager.newSession(login);
            sessionId = session.toString();
            JCRAccessControlManager accessManager = new JCRAccessControlManager(session, sessionManager.getLogin(request));
            if (absPath == null) {
                Node node = session.getNodeByIdentifier(id);
                absPath = node.getPath();
            }
            Boolean flag = accessManager.canReadNode(absPath);
            logger.debug("Can " + session.getUserID() + " read node " + absPath + "? " + flag);
            xmlConfig = xstream.toXML((Object)flag);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
            out.close();
            out.flush();
            if (session == null) return;
        }
        catch (Exception e) {
            try {
                logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                out.close();
                out.flush();
                if (session == null) return;
            }
            catch (Throwable throwable) {
                if (session == null) throw throwable;
                sessionManager.releaseSession(sessionId);
                throw throwable;
            }
            sessionManager.releaseSession(sessionId);
            return;
        }
        sessionManager.releaseSession(sessionId);
        return;
    }
}

