/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.accessmanager.privileges;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.acl.JCRAccessControlManager;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanDelete
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CanDelete.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        boolean isRoot = Boolean.valueOf(request.getParameter("isRoot"));
        String id = null;
        try {
            id = request.getParameter("id");
        }
        catch (Exception e) {
            logger.info("CanModifyProperties servlet - ID path not set ");
        }
        String absPath = null;
        try {
            absPath = URLDecoder.decode(request.getParameter("absPath"), "UTF-8");
        }
        catch (Exception e) {
            logger.info("CanDelete servlet - ABS path not set ");
        }
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(login);
                sessionId = session.toString();
            }
            try {
                JCRAccessControlManager accessManager = new JCRAccessControlManager(session, sessionManager.getLogin(request));
                if (absPath == null) {
                    Node node = session.getNodeByIdentifier(id);
                    absPath = node.getPath();
                }
                Boolean flag = accessManager.canDelete(session.getUserID(), absPath, isRoot);
                logger.debug("Can " + session.getUserID() + " delete node " + absPath + "? " + flag);
                xmlConfig = xstream.toXML((Object)flag);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error checking ACL CanAddChildren of item: " + absPath, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }
}

