/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.privilegemanager;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRPrivilegeManager {
    private Logger logger = LoggerFactory.getLogger(JCRPrivilegeManager.class);
    private PrivilegeManager privilegeManager;

    public JCRPrivilegeManager(SessionImpl session) throws InternalErrorException {
        JackrabbitWorkspace jrws = (JackrabbitWorkspace)session.getWorkspace();
        try {
            this.privilegeManager = jrws.getPrivilegeManager();
        }
        catch (RepositoryException e) {
            this.logger.error("Error getting privilegeManager ", (Throwable)e);
        }
    }

    public void createCostumePrivilege(String name, String[] declaredAggregateNames) throws RepositoryException {
        this.logger.info("Create Costume Privilege ");
        Privilege[] privileges = this.privilegeManager.getRegisteredPrivileges();
        for (int i = 0; i < privileges.length; ++i) {
            this.logger.debug(privileges[i].getName());
        }
        this.logger.debug("getPrivilege " + name);
        try {
            Privilege priv = this.privilegeManager.getPrivilege(name);
            this.logger.debug("Privilege already exists: " + priv.getName());
        }
        catch (AccessControlException e) {
            this.logger.error("catch " + (Object)((Object)e));
            try {
                this.privilegeManager.registerPrivilege(name, false, declaredAggregateNames);
            }
            catch (Exception e1) {
                this.logger.error("Error registering privilege " + name + " - " + e1);
            }
        }
        this.logger.debug("getRegisteredPrivileges 2 ");
        Privilege[] privileges1 = this.privilegeManager.getRegisteredPrivileges();
        for (int i = 0; i < privileges1.length; ++i) {
            this.logger.debug(privileges1[i].getName());
        }
    }

    public List<String> getRegisteredPrivileges() throws RepositoryException {
        this.logger.info("Get Registered Privileges ");
        ArrayList<String> mylist = new ArrayList<String>();
        Privilege[] privileges = this.privilegeManager.getRegisteredPrivileges();
        for (int i = 0; i < privileges.length; ++i) {
            this.logger.info(privileges[i].getName());
            mylist.add(privileges[i].getName());
        }
        return mylist;
    }
}

