/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clone
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(Clone.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String srcAbsPath = URLDecoder.decode(request.getParameter("srcAbsPath"), "UTF-8");
        String destAbsPath = URLDecoder.decode(request.getParameter("destAbsPath"), "UTF-8");
        String removeExisting = request.getParameter("removeExisting");
        logger.debug("Servlet Clone called with parameters: [srcAbsPath: " + srcAbsPath + " - destAbsPath: " + destAbsPath + " - removeExisting: " + removeExisting + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            ItemDelegate new_item = this.cloneItem(session, srcAbsPath, destAbsPath, Boolean.valueOf(removeExisting).booleanValue(), sessionManager.getLogin(request));
            xmlConfig = xstream.toXML((Object)new_item);
            out.println(xmlConfig);
        }
        catch (Exception e) {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            throw new ServletException((Throwable)e);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private ItemDelegate cloneItem(Session session, String srcAbsPath, String destAbsPath, boolean removeExisting, String login) throws RepositoryException {
        ItemDelegate item = null;
        try {
            session.getWorkspace().clone(session.getWorkspace().getName(), srcAbsPath, destAbsPath, removeExisting);
            Node node = session.getNode(destAbsPath);
            NodeManager wrap = new NodeManager(node, login);
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            throw new RepositoryException("Error getting clone of node " + srcAbsPath + " : " + e.getMessage());
        }
        return item;
    }
}

