/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.post;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyContent
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CopyContent.class);
    private static final long serialVersionUID = 1L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String srcAbsPath = URLDecoder.decode(request.getParameter("srcAbsPath"), "UTF-8");
        String destAbsPath = URLDecoder.decode(request.getParameter("destAbsPath"), "UTF-8");
        logger.info("Servlet CopyContent called with parameters: [srcAbsPath11: " + srcAbsPath + " - destAbsPath11: " + destAbsPath + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            ItemDelegate new_item = this.copyContetItem(session, srcAbsPath, destAbsPath, sessionManager.getLogin(request));
            xmlConfig = xstream.toXML((Object)new_item);
            out.println(xmlConfig);
        }
        catch (Exception e) {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            throw new ServletException((Throwable)e);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private ItemDelegate copyContetItem(Session session, String srcId, String destId, String login) throws Exception {
        Node nodeFolder = session.getNodeByIdentifier(destId);
        Node sharedNode = session.getNodeByIdentifier(srcId);
        ItemDelegate item = null;
        NodeIterator iterator = sharedNode.getNodes();
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            if (child.getName().startsWith("hl:") || child.getName().startsWith("jcr:") || child.getName().startsWith("rep:")) continue;
            session.getWorkspace().copy(child.getPath(), nodeFolder.getPath() + "/" + child.getName());
        }
        NodeManager wrap = new NodeManager(nodeFolder, login);
        item = wrap.getItemDelegate();
        return item;
    }
}

