/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin.utils;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Classification;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.speciesplugin.store.SpeciesStore;
import org.gcube.data.speciesplugin.utils.SpeciesTreeGenerator;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.PipedStream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeciesService {
    private static Logger logger = LoggerFactory.getLogger(SpeciesService.class);
    public static final QName SPECIES_SERVICE_ID = new QName("SpeciesServiceId");
    protected static final SpeciesTreeGenerator GENERATOR = new SpeciesTreeGenerator();
    protected Manager call;
    protected Classification classificationCall;
    protected SpeciesStore store;
    protected int treeCounter = 0;

    public SpeciesService(SpeciesStore store) throws Exception {
        this.store = store;
        logger.trace("getting SPD calls in " + GCUBEScopeManager.DEFAULT.getScope());
        this.call = (Manager)AbstractPlugin.manager().withTimeout(5, TimeUnit.MINUTES).build();
        this.classificationCall = (Classification)AbstractPlugin.classification().withTimeout(5, TimeUnit.MINUTES).build();
    }

    public void createCollection(List<String> scientificNames, List<String> dataSources) throws Exception {
        this.createCollection(scientificNames, dataSources, true);
    }

    public void createCollection(List<String> scientificNames, List<String> dataSources, boolean strictMatch) throws Exception {
        logger.trace("retrieving trees with scientificNames: " + scientificNames + " dataSources: " + dataSources + " strictMatch: " + strictMatch + " scope: " + GCUBEScopeManager.DEFAULT.getScope());
        if (scientificNames.size() == 0) {
            throw new IllegalArgumentException("No scientific name specified");
        }
        this.treeCounter = 0;
        String query = this.createQuery(scientificNames, dataSources);
        logger.trace("SPD query: " + query);
        Stream stream = this.call.search(query.toString());
        logger.trace("Filtering retrieved scientific names (strictMatch: " + strictMatch + ")");
        int skipped = 0;
        int accepted = 0;
        while (stream.hasNext()) {
            TaxonomyItem taxon = (TaxonomyItem)stream.next();
            if (!strictMatch || this.checkEquals(scientificNames, taxon.getScientificName())) {
                logger.trace("Accepted " + taxon.getId() + " " + taxon.getScientificName());
                ++accepted;
                this.store(taxon);
                continue;
            }
            ++skipped;
        }
        logger.trace("Species trees retrieving complete with {} trees", (Object)this.treeCounter);
        logger.trace("Scientific Names {} accepted, {} skipped", (Object)accepted, (Object)skipped);
        logger.trace("Store size {}", (Object)this.store.cardinality());
    }

    protected String createQuery(List<String> scientificNames, List<String> dataSource) {
        if (scientificNames.size() == 0) {
            throw new IllegalArgumentException("No scientific name specified");
        }
        StringBuilder query = new StringBuilder();
        query.append("SEARCH BY SN ");
        Iterator<String> itScNames = scientificNames.iterator();
        while (itScNames.hasNext()) {
            query.append("'");
            query.append(itScNames.next());
            query.append("'");
            if (!itScNames.hasNext()) continue;
            query.append(", ");
        }
        if (dataSource != null && dataSource.size() > 0) {
            query.append(" IN ");
            Iterator<String> itDataSource = dataSource.iterator();
            while (itDataSource.hasNext()) {
                query.append(itDataSource.next());
                if (!itDataSource.hasNext()) continue;
                query.append(", ");
            }
        }
        query.append(" RETURN TAXON");
        logger.info(query.toString());
        return query.toString();
    }

    private boolean checkEquals(List<String> scientificNames, String scientificName) {
        for (String name : scientificNames) {
            if (!name.equalsIgnoreCase(scientificName)) continue;
            return true;
        }
        return false;
    }

    protected void store(TaxonomyItem taxon) {
        logger.trace("retrieving Taxonomy subtree for {} {}", (Object)taxon.getId(), (Object)taxon.getScientificName());
        try {
            Stream taxonomyItems = this.classificationCall.getTaxonTreeById(taxon.getId());
            PipedStream trees = Streams.pipe((Stream)taxonomyItems).through((Generator)GENERATOR);
            Stream<Tree> outcomes = this.store.add((Stream<Tree>)trees);
            int i = 0;
            while (outcomes.hasNext()) {
                ++this.treeCounter;
                outcomes.next();
                if (++i % 100 != 0) continue;
                logger.trace("Generated {} trees, generation ongoing...", (Object)i);
            }
            logger.trace("Generated {} trees from taxon {}", (Object)i, (Object)(taxon.getId() + " " + taxon.getScientificName()));
        }
        catch (Exception e) {
            logger.error("Failed tree generation for taxon " + taxon.getId() + " " + taxon.getScientificName(), (Throwable)e);
        }
    }
}

