/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams;

import java.util.NoSuchElementException;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.exceptions.StreamSkipException;
import org.gcube.data.streams.handlers.FaultHandler;
import org.gcube.data.streams.handlers.FaultResponse;
import org.gcube.data.streams.handlers.RethrowHandler;

public abstract class LookAheadStream<E>
implements Stream<E> {
    private FaultHandler handler = new RethrowHandler();
    protected Boolean hasNext;
    protected E element;
    private RuntimeException failure;

    public void setHandler(FaultHandler handler) throws IllegalArgumentException {
        if (handler == null) {
            throw new IllegalArgumentException("invalid null handler");
        }
        this.handler = handler;
    }

    @Override
    public final boolean hasNext() {
        if (this.hasNext == null) {
            this.hasNext = this.lookAhead();
        }
        if (!this.hasNext.booleanValue()) {
            this.close();
        }
        return this.hasNext;
    }

    private boolean lookAhead() {
        if (!this.delegateHasNext()) {
            return false;
        }
        try {
            this.element = this.delegateNext();
        }
        catch (RuntimeException failure) {
            try {
                if (this.shouldIgnore(failure)) {
                    return this.lookAhead();
                }
                return false;
            }
            catch (RuntimeException rethrown) {
                this.failure = rethrown;
            }
        }
        return true;
    }

    private boolean shouldIgnore(RuntimeException failure) {
        if (failure instanceof StreamSkipException) {
            return true;
        }
        return this.handler.handle(failure) == FaultResponse.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E next() {
        try {
            this.throwLookAheadFailureIfAny();
            E e = this.lookedAheadElementOrGetItNow();
            return e;
        }
        finally {
            this.cleanIterationState();
        }
    }

    private void throwLookAheadFailureIfAny() {
        if (this.failure != null) {
            throw this.failure;
        }
    }

    private E lookedAheadElementOrGetItNow() {
        if (this.element == null) {
            if (this.hasNext()) {
                return this.next();
            }
            throw new NoSuchElementException();
        }
        return this.element;
    }

    private void cleanIterationState() {
        this.failure = null;
        this.element = null;
        this.hasNext = null;
    }

    protected abstract E delegateNext();

    protected abstract boolean delegateHasNext();
}

