/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.delegates;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.gcube.data.streams.LookAheadStream;
import org.gcube.data.streams.Stream;

public class FoldedStream<E>
extends LookAheadStream<List<E>> {
    private final Stream<E> stream;
    private final int foldSize;

    public FoldedStream(Stream<E> stream, int foldSize) throws IllegalArgumentException {
        if (stream == null) {
            throw new IllegalArgumentException("invalid null stream");
        }
        if (foldSize < 1) {
            throw new IllegalArgumentException("invalid foldsize is not positive");
        }
        this.stream = stream;
        this.foldSize = foldSize;
    }

    @Override
    protected List<E> delegateNext() {
        ArrayList<E> fold = new ArrayList<E>();
        for (int i = 0; i < this.foldSize; ++i) {
            if (!this.stream.hasNext()) continue;
            fold.add(this.stream.next());
        }
        return fold;
    }

    @Override
    protected boolean delegateHasNext() {
        return this.stream.hasNext();
    }

    @Override
    public void close() {
        this.stream.close();
    }

    @Override
    public URI locator() throws IllegalStateException {
        return this.stream.locator();
    }

    @Override
    public void remove() {
        this.stream.remove();
    }
}

