package org.gcube.data.streams.handlers;

import org.gcube.data.streams.Stream;
import org.gcube.data.streams.exceptions.StreamContingencyException;

/**
 * Handlers of {@link Stream} iteration failures.
 * @author Fabio Simeoni
 *
 */
public interface FaultHandler {

	/**
	 * Indicates whether iteration should continue or stop the iteration on the occurrence of an iteration failure.
	 * @param failure the failure
	 * @return the {@link FaultResponse}
	 * @throws StreamContingencyException if no element can be yielded, because the input element violates pre-conditions
	 * @throws RuntimeException if no element can be yielded from the input element, because of an unrecoverable condition
	 * 
	 */
	FaultResponse handle(RuntimeException failure) throws StreamContingencyException,RuntimeException;
}
