package org.gcube.data.streams.handlers;

import org.gcube.data.streams.exceptions.StreamContingencyException;

/**
 * A {@link FaultHandler} that silently absorbs {@link StreamContingencyException}s
 * but re-throws all other failures.
 * 
 * @author Fabio Simeoni
 *
 */
public class RethrowUnrecoverableHandler implements FaultHandler {

	@Override
	public FaultResponse handle(RuntimeException failure) {
		
		if (failure instanceof StreamContingencyException)
			return FaultResponse.CONTINUE;
		
		throw failure;
	}
}
