package org.gcube.data.streams.handlers;

import org.gcube.data.streams.exceptions.StreamContingencyException;

/**
 * A {@link FaultHandler} that silently absorbs {@link StreamContingencyException}s
 * and stops iteration at the first unrecoverable failure.
 * 
 * @author Fabio Simeoni
 *
 */
public class StopUnrecoverableHandler implements FaultHandler {

	@Override
	public FaultResponse handle(RuntimeException failure) {

		if (failure instanceof StreamContingencyException)
			return FaultResponse.CONTINUE;
		else
			return FaultResponse.STOP;
	}
}
