/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.adapters;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.Record;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.gcube.data.streams.LookAheadStream;
import org.gcube.data.streams.exceptions.StreamOpenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultsetStream<E extends Record>
extends LookAheadStream<E> {
    private static Logger log = LoggerFactory.getLogger(ResultsetStream.class);
    public static final int default_timeout = 30;
    public static final TimeUnit default_timeout_unit = TimeUnit.SECONDS;
    private final URI locator;
    private long timeout = 30L;
    private TimeUnit timeoutUnit = default_timeout_unit;
    private boolean open = false;
    private boolean closed = false;
    private RuntimeException lookAheadFailure;
    private ForwardReader<E> reader;
    private Iterator<E> iterator;

    public ResultsetStream(URI locator) throws IllegalArgumentException {
        if (locator == null) {
            throw new IllegalArgumentException("invalid or null locator");
        }
        this.locator = locator;
    }

    public void setTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        if (timeout <= 0L || this.timeoutUnit == null) {
            throw new IllegalArgumentException("invalid timeout or null timeout unit");
        }
        this.timeout = timeout;
        this.timeoutUnit = unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected E delegateNext() {
        try {
            if (this.lookAheadFailure != null) {
                throw this.lookAheadFailure;
            }
            Record record = (Record)this.iterator.next();
            return (E)record;
        }
        finally {
            this.lookAheadFailure = null;
        }
    }

    @Override
    protected boolean delegateHasNext() {
        if (this.closed) {
            return false;
        }
        if (!this.open) {
            try {
                this.reader = new ForwardReader(this.locator);
                this.reader.setIteratorTimeout(this.timeout);
                this.reader.setIteratorTimeUnit(this.timeoutUnit);
            }
            catch (Throwable t) {
                this.lookAheadFailure = new StreamOpenException("cannot open resultset " + this.locator, t);
                return true;
            }
        }
        this.iterator = this.reader.iterator();
        log.trace("initialised resultset at " + this.locator);
        this.open = true;
        if (this.reader.getStatus() == IBuffer.Status.Dispose && !this.closed) {
            this.lookAheadFailure = new RuntimeException("unrecoverable failure in resultset ");
        }
        boolean hasNext = this.iterator.hasNext();
        return hasNext;
    }

    @Override
    public void close() {
        try {
            this.closed = true;
            if (this.open) {
                this.reader.close();
            }
            log.trace("closed resultset at " + this.locator);
        }
        catch (GRS2ReaderException e) {
            log.error("could not close resultset", (Throwable)e);
        }
    }

    @Override
    public URI locator() throws IllegalStateException {
        if (this.open) {
            throw new IllegalStateException("locator is invalid as result set has already been opened");
        }
        return this.locator;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

