/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.dsl;

import gr.uoa.di.madgik.grs.record.Record;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.adapters.IteratorAdapter;
import org.gcube.data.streams.adapters.IteratorStream;
import org.gcube.data.streams.dsl.consume.ConsumeWithClause;
import org.gcube.data.streams.dsl.fold.InClause;
import org.gcube.data.streams.dsl.from.RsOfClause;
import org.gcube.data.streams.dsl.guard.GuardWithClause;
import org.gcube.data.streams.dsl.listen.MonitorWithClause;
import org.gcube.data.streams.dsl.pipe.PipeThroughClause;
import org.gcube.data.streams.dsl.publish.PublishRsUsingClause;
import org.gcube.data.streams.dsl.publish.PublishRsWithClause;
import org.gcube.data.streams.dsl.unfold.UnfoldThroughClause;
import org.gcube.data.streams.generators.LoggingListener;
import org.gcube.data.streams.generators.NoOpGenerator;
import org.gcube.data.streams.handlers.FaultHandler;
import org.gcube.data.streams.handlers.IgnoreHandler;
import org.gcube.data.streams.handlers.RethrowHandler;
import org.gcube.data.streams.handlers.RethrowUnrecoverableHandler;
import org.gcube.data.streams.handlers.StopFastHandler;
import org.gcube.data.streams.test.FallibleIterator;

public class Streams {
    public static NoOpGenerator<String> no_serialiser = new NoOpGenerator();
    public static FaultHandler RETHROW_POLICY = new RethrowHandler();
    public static FaultHandler RETHROW_UNRECOVERABLE_POLICY = new RethrowUnrecoverableHandler();
    public static FaultHandler STOPFAST_POLICY = new StopFastHandler();
    public static FaultHandler IGNORE_POLICY = new IgnoreHandler();

    public static <E> ConsumeWithClause<E> consume(Stream<E> stream) {
        return new ConsumeWithClause<E>(stream);
    }

    public static <E> Stream<E> convert(Iterator<E> itarator) {
        return new IteratorStream<E>(itarator);
    }

    public static <E> IteratorStream<E> convert(IteratorAdapter<E> adapter) {
        return new IteratorStream<E>(adapter);
    }

    public static <E> Stream<E> convert(Iterable<E> iterable) {
        return Streams.convert(iterable.iterator());
    }

    public static <E> Stream<E> convert(E ... elements) {
        return Streams.convert(Arrays.asList(elements));
    }

    public static <E> Stream<E> convertWithFaults(Class<E> clazz, Object ... elements) {
        return Streams.convertWithFaults(clazz, Arrays.asList(elements));
    }

    public static <E> Stream<E> convertWithFaults(Class<E> clazz, List<? extends Object> elements) {
        return Streams.convert(new FallibleIterator<E>(clazz, elements));
    }

    public static RsOfClause<Record> convert(URI locator) {
        return new RsOfClause<Record>(locator);
    }

    public static Stream<String> stringsIn(URI locator) {
        return Streams.convert(locator).ofStrings().withDefaults();
    }

    public static <E> PipeThroughClause<E> pipe(Stream<E> stream) {
        return new PipeThroughClause<E>(stream);
    }

    public static <E> InClause<E> fold(Stream<E> stream) {
        return new InClause<E>(stream);
    }

    public static <E> UnfoldThroughClause<E> unfold(Stream<E> stream) {
        return new UnfoldThroughClause<E>(stream);
    }

    public static <E> GuardWithClause<E> guard(Stream<E> stream) {
        return new GuardWithClause<E>(stream);
    }

    public static <E> MonitorWithClause<E> monitor(Stream<E> stream) {
        return new MonitorWithClause<E>(stream);
    }

    public static <E> PublishRsUsingClause<E> publish(Stream<E> stream) {
        return new PublishRsUsingClause<E>(stream);
    }

    public static PublishRsWithClause<String> publishStringsIn(Stream<String> stream) {
        return new PublishRsUsingClause<String>(stream).using(no_serialiser);
    }

    public static <E> Stream<E> log(Stream<E> stream) {
        LoggingListener listener = new LoggingListener();
        return Streams.monitor(Streams.pipe(stream).through(listener)).with(listener);
    }

    public static <E> NoOpGenerator<E> no_op(Stream<E> stream) {
        return new NoOpGenerator();
    }
}

