/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.state;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.state.GCUBEWSLiteResource;
import org.gcube.common.core.state.GCUBEWSResourcePropertyProxy;
import org.gcube.common.core.state.GCUBEWSResourcePropertySet;
import org.gcube.common.core.types.DescriptiveProperty;
import org.gcube.data.tm.Constants;
import org.gcube.data.tm.state.SourceResource;
import org.gcube.data.tm.stubs.UpdateNotificationType;
import org.gcube.data.tm.stubs.UpdateNotificationTypeWrapper;
import org.gcube.data.tmf.api.Property;
import org.gcube.data.tmf.api.Source;
import org.gcube.data.tmf.api.SourceConsumer;
import org.gcube.data.tmf.api.SourceEvent;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.Topic;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleTopic;

public abstract class AccessorResource
extends GCUBEWSLiteResource<SourceResource>
implements SourceConsumer {
    protected static final int PART_SIZE = 10;
    private static final int DEFAULT_CHANGE_COALESCING_DELAY = 60;
    private Thread notifier;
    private SimpleTopic updateTopic = new SimpleTopic(Constants.UPDATETOPIC_QNAME);

    protected void initialise(Object ... params) throws Exception {
        this.subscribeForChange();
    }

    protected String[] getPropertyNames() {
        return new String[0];
    }

    protected void initialiseContainers() throws Exception {
        super.initialiseContainers();
        this.getResourcePropertySet().add((ResourceProperty)new ReflectionResourceProperty(Constants.SOURCEID_RP, (Object)this));
        this.getResourcePropertySet().add((ResourceProperty)new ReflectionResourceProperty(Constants.SOURCENAME_RP, (Object)this));
        this.getResourcePropertySet().add((ResourceProperty)new ReflectionResourceProperty(Constants.SOURCETYPE_RP, (Object)this));
        this.getResourcePropertySet().add((ResourceProperty)new ReflectionResourceProperty(Constants.PROPERTY_RP, (Object)this));
        this.getResourcePropertySet().add((ResourceProperty)new ReflectionResourceProperty(Constants.PLUGIN_RP, (Object)this));
        ReflectionResourceProperty cardinality = new ReflectionResourceProperty(Constants.CARDINALITY_RP, (Object)this);
        this.getResourcePropertySet().add((ResourceProperty)cardinality);
        ReflectionResourceProperty lastUpdate = new ReflectionResourceProperty(Constants.LAST_UPDATE_RP, (Object)this);
        this.getResourcePropertySet().add((ResourceProperty)lastUpdate);
        this.getTopicList().addTopic((Topic)this.updateTopic);
    }

    public String getPlugin() throws ResourceException {
        return ((SourceResource)this.getLocalResource()).getPluginName();
    }

    public String getSourceId() throws ResourceException {
        return ((SourceResource)this.getLocalResource()).source().id();
    }

    public String getName() throws ResourceException {
        return ((SourceResource)this.getLocalResource()).source().name();
    }

    public Long getCardinality() throws ResourceException {
        return ((SourceResource)this.getLocalResource()).source().cardinality();
    }

    public Calendar getLastUpdate() throws ResourceException {
        return ((SourceResource)this.getLocalResource()).source().lastUpdate();
    }

    public QName[] getType() throws ResourceException {
        List types = ((SourceResource)this.getLocalResource()).source().types();
        return types == null ? null : types.toArray(new QName[0]);
    }

    public DescriptiveProperty[] getProperty() throws ResourceException {
        List properties = ((SourceResource)this.getLocalResource()).source().properties();
        if (properties != null) {
            ArrayList<DescriptiveProperty> descriptiveProperties = new ArrayList<DescriptiveProperty>();
            for (Property prop : properties) {
                DescriptiveProperty property = new DescriptiveProperty(prop.description(), prop.name(), (Object)prop.value());
                descriptiveProperties.add(property);
            }
            return descriptiveProperties.toArray(new DescriptiveProperty[0]);
        }
        return null;
    }

    protected void subscribeForChange() throws ResourceException {
        Source source = ((SourceResource)this.getLocalResource()).source();
        this.logger.trace((Object)((Object)((Object)this) + " is subscribing for changes to source " + source));
        source.notifier().subscribe((SourceConsumer)this, new SourceEvent[]{SourceEvent.CHANGE});
    }

    public void onEvent(SourceEvent ... events) {
        if (this.notifier != null && this.notifier.isAlive()) {
            return;
        }
        this.notifier = new Thread(((Object)((Object)this)).getClass().getSimpleName() + "-delayed"){

            @Override
            public void run() {
                try {
                    GCUBEWSResourcePropertySet set;
                    AccessorResource.this.logger.trace((Object)"will notify change in 60 second/s");
                    TimeUnit.SECONDS.sleep(60L);
                    AccessorResource.this.logger.trace((Object)("sending change notification (" + AccessorResource.this.getID() + ")"));
                    if (GHNContext.getContext().getMode() == GHNContext.Mode.CONNECTED) {
                        UpdateNotificationTypeWrapper message = new UpdateNotificationTypeWrapper(new UpdateNotificationType(AccessorResource.this.getCardinality().longValue(), AccessorResource.this.getSourceId(), AccessorResource.this.getLastUpdate()));
                        AccessorResource.this.updateTopic.notify((Object)message);
                    }
                    GCUBEWSResourcePropertySet gCUBEWSResourcePropertySet = set = AccessorResource.this.getResourcePropertySet();
                    gCUBEWSResourcePropertySet.getClass();
                    GCUBEWSResourcePropertySet.RPSetChange change = new GCUBEWSResourcePropertySet.RPSetChange(gCUBEWSResourcePropertySet, set.get(Constants.LAST_UPDATE_RP), GCUBEWSResourcePropertyProxy.ResourcePropertyEvent.UPDATED);
                    for (Field f : set.getClass().getDeclaredFields()) {
                        f.setAccessible(true);
                        if (!(f.get(set) instanceof Observable)) continue;
                        ((Observable)Observable.class.cast(f.get(set))).notifyObservers(change);
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    AccessorResource.this.logger.error((Object)"unexpected interruption", (Throwable)ex);
                }
                catch (Exception e) {
                    AccessorResource.this.logger.warn((Object)(AccessorResource.this.getID() + " could not send change notification"), (Throwable)e);
                }
            }
        };
        this.notifier.start();
    }
}

