/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.patterns;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;

@XmlRootElement(name="opt")
public class OptPattern
extends EdgePattern {
    private static final long serialVersionUID = 1L;
    private static EdgePattern.Range RANGE = new EdgePattern.Range(0, 1);
    static final String NAME = "opt";

    OptPattern() {
    }

    public OptPattern(QName l, Pattern p) {
        super(l, p);
    }

    @Override
    public boolean matches(List<Edge> edges) {
        if (edges.size() > 1) {
            return false;
        }
        return edges.size() == 0 || this.pattern().matches(edges.get(0).target());
    }

    @Override
    public List<Edge> prune(List<Edge> edges) throws Exception {
        if (edges.size() > 1) {
            throw new Exception("expected at most one " + this.label());
        }
        ArrayList<Edge> matched = new ArrayList<Edge>();
        if (edges.size() == 1) {
            Edge edge = edges.get(0);
            try {
                this.pattern().prune(edge.target());
                matched.add(edge);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return matched;
    }

    @Override
    public EdgePattern.Range range() {
        return RANGE;
    }

    @Override
    public String name() {
        return NAME;
    }
}

