/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.BodyConsumer;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Part;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.ResumableBodyConsumer;
import com.ning.http.client.SSLEngineFactory;
import com.ning.http.client.ThrowableHandler;
import com.ning.http.client.resumable.ResumableAsyncHandler;
import com.ning.http.client.resumable.ResumableIOExceptionFilter;
import com.ning.http.client.simple.HeaderMap;
import com.ning.http.client.simple.SimpleAHCTransferListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAsyncHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(SimpleAsyncHttpClient.class);
    private final AsyncHttpClientConfig config;
    private final RequestBuilder requestBuilder;
    private AsyncHttpClient asyncHttpClient;
    private final ThrowableHandler defaultThrowableHandler;
    private final boolean resumeEnabled;
    private final ErrorDocumentBehaviour errorDocumentBehaviour;
    private final SimpleAHCTransferListener listener;
    private final boolean derived;

    private SimpleAsyncHttpClient(AsyncHttpClientConfig config, RequestBuilder requestBuilder, ThrowableHandler defaultThrowableHandler, ErrorDocumentBehaviour errorDocumentBehaviour, boolean resumeEnabled, AsyncHttpClient ahc, SimpleAHCTransferListener listener) {
        this.config = config;
        this.requestBuilder = requestBuilder;
        this.defaultThrowableHandler = defaultThrowableHandler;
        this.resumeEnabled = resumeEnabled;
        this.errorDocumentBehaviour = errorDocumentBehaviour;
        this.asyncHttpClient = ahc;
        this.listener = listener;
        this.derived = ahc != null;
    }

    public Future<Response> post(Part ... parts) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        for (Part part : parts) {
            r.addBodyPart(part);
        }
        return this.execute(r, null, null);
    }

    public Future<Response> post(BodyConsumer consumer, Part ... parts) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        for (Part part : parts) {
            r.addBodyPart(part);
        }
        return this.execute(r, consumer, null);
    }

    public Future<Response> post(BodyGenerator bodyGenerator) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        r.setBody(bodyGenerator);
        return this.execute(r, null, null);
    }

    public Future<Response> post(BodyGenerator bodyGenerator, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        r.setBody(bodyGenerator);
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> post(BodyGenerator bodyGenerator, BodyConsumer bodyConsumer) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        r.setBody(bodyGenerator);
        return this.execute(r, bodyConsumer, null);
    }

    public Future<Response> post(BodyGenerator bodyGenerator, BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        r.setBody(bodyGenerator);
        return this.execute(r, bodyConsumer, throwableHandler);
    }

    public Future<Response> put(Part ... parts) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        for (Part part : parts) {
            r.addBodyPart(part);
        }
        return this.execute(r, null, null);
    }

    public Future<Response> put(BodyConsumer consumer, Part ... parts) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        for (Part part : parts) {
            r.addBodyPart(part);
        }
        return this.execute(r, consumer, null);
    }

    public Future<Response> put(BodyGenerator bodyGenerator, BodyConsumer bodyConsumer) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("PUT");
        r.setBody(bodyGenerator);
        return this.execute(r, bodyConsumer, null);
    }

    public Future<Response> put(BodyGenerator bodyGenerator, BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("PUT");
        r.setBody(bodyGenerator);
        return this.execute(r, bodyConsumer, throwableHandler);
    }

    public Future<Response> put(BodyGenerator bodyGenerator) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("PUT");
        r.setBody(bodyGenerator);
        return this.execute(r, null, null);
    }

    public Future<Response> put(BodyGenerator bodyGenerator, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("PUT");
        r.setBody(bodyGenerator);
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> get() throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        return this.execute(r, null, null);
    }

    public Future<Response> get(ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> get(BodyConsumer bodyConsumer) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        return this.execute(r, bodyConsumer, null);
    }

    public Future<Response> get(BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        return this.execute(r, bodyConsumer, throwableHandler);
    }

    public Future<Response> delete() throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("DELETE");
        return this.execute(r, null, null);
    }

    public Future<Response> delete(ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("DELETE");
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> delete(BodyConsumer bodyConsumer) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("DELETE");
        return this.execute(r, bodyConsumer, null);
    }

    public Future<Response> delete(BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("DELETE");
        return this.execute(r, bodyConsumer, throwableHandler);
    }

    public Future<Response> head() throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("HEAD");
        return this.execute(r, null, null);
    }

    public Future<Response> head(ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("HEAD");
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> options() throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("OPTIONS");
        return this.execute(r, null, null);
    }

    public Future<Response> options(ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("OPTIONS");
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> options(BodyConsumer bodyConsumer) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("OPTIONS");
        return this.execute(r, bodyConsumer, null);
    }

    public Future<Response> options(BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("OPTIONS");
        return this.execute(r, bodyConsumer, throwableHandler);
    }

    private RequestBuilder rebuildRequest(Request rb) {
        return new RequestBuilder(rb);
    }

    private Future<Response> execute(RequestBuilder rb, BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        if (throwableHandler == null) {
            throwableHandler = this.defaultThrowableHandler;
        }
        Request request = rb.build();
        ProgressAsyncHandler<Response> handler = new BodyConsumerAsyncHandler(bodyConsumer, throwableHandler, this.errorDocumentBehaviour, request.getUrl(), this.listener);
        if (this.resumeEnabled && request.getMethod().equals("GET") && bodyConsumer != null && bodyConsumer instanceof ResumableBodyConsumer) {
            ResumableBodyConsumer fileBodyConsumer = (ResumableBodyConsumer)bodyConsumer;
            long length = fileBodyConsumer.getTransferredBytes();
            fileBodyConsumer.resume();
            handler = new ResumableBodyConsumerAsyncHandler(length, handler);
        }
        return this.asyncHttpClient().executeRequest(request, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncHttpClient asyncHttpClient() {
        AsyncHttpClientConfig asyncHttpClientConfig = this.config;
        synchronized (asyncHttpClientConfig) {
            if (this.asyncHttpClient == null) {
                this.asyncHttpClient = new AsyncHttpClient(this.config);
            }
        }
        return this.asyncHttpClient;
    }

    public void close() {
        if (!this.derived && this.asyncHttpClient != null) {
            this.asyncHttpClient.close();
        }
    }

    public DerivedBuilder derive() {
        return new Builder(this);
    }

    private static final class BodyConsumerAsyncHandler
    extends AsyncCompletionHandlerBase {
        private final BodyConsumer bodyConsumer;
        private final ThrowableHandler exceptionHandler;
        private final ErrorDocumentBehaviour errorDocumentBehaviour;
        private final String url;
        private final SimpleAHCTransferListener listener;
        private boolean accumulateBody = false;
        private boolean omitBody = false;
        private int amount = 0;
        private long total = -1L;

        public BodyConsumerAsyncHandler(BodyConsumer bodyConsumer, ThrowableHandler exceptionHandler, ErrorDocumentBehaviour errorDocumentBehaviour, String url, SimpleAHCTransferListener listener) {
            this.bodyConsumer = bodyConsumer;
            this.exceptionHandler = exceptionHandler;
            this.errorDocumentBehaviour = errorDocumentBehaviour;
            this.url = url;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onThrowable(Throwable t) {
            try {
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.onThrowable(t);
                } else {
                    super.onThrowable(t);
                }
            }
            finally {
                this.closeConsumer();
            }
        }

        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
            this.fireReceived(content);
            if (this.omitBody) {
                return AsyncHandler.STATE.CONTINUE;
            }
            if (this.accumulateBody || this.bodyConsumer == null) {
                return super.onBodyPartReceived(content);
            }
            this.bodyConsumer.consume(content.getBodyByteBuffer());
            return AsyncHandler.STATE.CONTINUE;
        }

        public Response onCompleted(Response response) throws Exception {
            this.fireCompleted(response);
            this.closeConsumer();
            return super.onCompleted(response);
        }

        private void closeConsumer() {
            try {
                if (this.bodyConsumer != null) {
                    this.bodyConsumer.close();
                }
            }
            catch (IOException ex) {
                logger.warn("Unable to close a BodyConsumer {}", (Object)this.bodyConsumer);
            }
        }

        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
            this.fireStatus(status);
            if (this.isErrorStatus(status)) {
                switch (this.errorDocumentBehaviour) {
                    case ACCUMULATE: {
                        this.accumulateBody = true;
                        break;
                    }
                    case OMIT: {
                        this.omitBody = true;
                        break;
                    }
                }
            }
            return super.onStatusReceived(status);
        }

        private boolean isErrorStatus(HttpResponseStatus status) {
            return status.getStatusCode() >= 400;
        }

        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            this.calculateTotal(headers);
            this.fireHeaders(headers);
            return super.onHeadersReceived(headers);
        }

        private void calculateTotal(HttpResponseHeaders headers) {
            String length = headers.getHeaders().getFirstValue("Content-Length");
            try {
                this.total = Integer.valueOf(length).intValue();
            }
            catch (Exception e) {
                this.total = -1L;
            }
        }

        public AsyncHandler.STATE onContentWriteProgress(long amount, long current, long total) {
            this.fireSent(this.url, amount, current, total);
            return super.onContentWriteProgress(amount, current, total);
        }

        private void fireStatus(HttpResponseStatus status) {
            if (this.listener != null) {
                this.listener.onStatus(this.url, status.getStatusCode(), status.getStatusText());
            }
        }

        private void fireReceived(HttpResponseBodyPart content) {
            int remaining = content.getBodyByteBuffer().remaining();
            this.amount += remaining;
            if (this.listener != null) {
                this.listener.onBytesReceived(this.url, this.amount, remaining, this.total);
            }
        }

        private void fireHeaders(HttpResponseHeaders headers) {
            if (this.listener != null) {
                this.listener.onHeaders(this.url, new HeaderMap(headers.getHeaders()));
            }
        }

        private void fireSent(String url, long amount, long current, long total) {
            if (this.listener != null) {
                this.listener.onBytesSent(url, amount, current, total);
            }
        }

        private void fireCompleted(Response response) {
            if (this.listener != null) {
                this.listener.onCompleted(this.url, response.getStatusCode(), response.getStatusText());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResumableBodyConsumerAsyncHandler
    extends ResumableAsyncHandler<Response>
    implements ProgressAsyncHandler<Response> {
        private final ProgressAsyncHandler<Response> delegate;

        public ResumableBodyConsumerAsyncHandler(long byteTransferred, ProgressAsyncHandler<Response> delegate) {
            super(byteTransferred, delegate);
            this.delegate = delegate;
        }

        @Override
        public AsyncHandler.STATE onHeaderWriteCompleted() {
            return this.delegate.onHeaderWriteCompleted();
        }

        @Override
        public AsyncHandler.STATE onContentWriteCompleted() {
            return this.delegate.onContentWriteCompleted();
        }

        @Override
        public AsyncHandler.STATE onContentWriteProgress(long amount, long current, long total) {
            return this.delegate.onContentWriteProgress(amount, current, total);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder
    implements DerivedBuilder {
        private final RequestBuilder requestBuilder;
        private final AsyncHttpClientConfig.Builder configBuilder = new AsyncHttpClientConfig.Builder();
        private Realm.RealmBuilder realmBuilder = null;
        private ProxyServer.Protocol proxyProtocol = null;
        private String proxyHost = null;
        private String proxyPrincipal = null;
        private String proxyPassword = null;
        private int proxyPort = 80;
        private ThrowableHandler defaultThrowableHandler = null;
        private boolean enableResumableDownload = false;
        private ErrorDocumentBehaviour errorDocumentBehaviour = ErrorDocumentBehaviour.WRITE;
        private AsyncHttpClient ahc = null;
        private SimpleAHCTransferListener listener = null;

        public Builder() {
            this.requestBuilder = new RequestBuilder("GET", false);
        }

        private Builder(SimpleAsyncHttpClient client) {
            this.requestBuilder = new RequestBuilder(client.requestBuilder.build());
            this.defaultThrowableHandler = client.defaultThrowableHandler;
            this.errorDocumentBehaviour = client.errorDocumentBehaviour;
            this.enableResumableDownload = client.resumeEnabled;
            this.ahc = client.asyncHttpClient();
            this.listener = client.listener;
        }

        @Override
        public Builder addBodyPart(Part part) throws IllegalArgumentException {
            this.requestBuilder.addBodyPart(part);
            return this;
        }

        @Override
        public Builder addCookie(Cookie cookie) {
            this.requestBuilder.addCookie(cookie);
            return this;
        }

        @Override
        public Builder addHeader(String name, String value) {
            this.requestBuilder.addHeader(name, value);
            return this;
        }

        @Override
        public Builder addParameter(String key, String value) throws IllegalArgumentException {
            this.requestBuilder.addParameter(key, value);
            return this;
        }

        @Override
        public Builder addQueryParameter(String name, String value) {
            this.requestBuilder.addQueryParameter(name, value);
            return this;
        }

        @Override
        public Builder setHeader(String name, String value) {
            this.requestBuilder.setHeader(name, value);
            return this;
        }

        @Override
        public Builder setHeaders(FluentCaseInsensitiveStringsMap headers) {
            this.requestBuilder.setHeaders(headers);
            return this;
        }

        @Override
        public Builder setHeaders(Map<String, Collection<String>> headers) {
            this.requestBuilder.setHeaders((Map)headers);
            return this;
        }

        @Override
        public Builder setParameters(Map<String, Collection<String>> parameters) throws IllegalArgumentException {
            this.requestBuilder.setParameters((Map)parameters);
            return this;
        }

        @Override
        public Builder setParameters(FluentStringsMap parameters) throws IllegalArgumentException {
            this.requestBuilder.setParameters(parameters);
            return this;
        }

        @Override
        public Builder setUrl(String url) {
            this.requestBuilder.setUrl(url);
            return this;
        }

        @Override
        public Builder setVirtualHost(String virtualHost) {
            this.requestBuilder.setVirtualHost(virtualHost);
            return this;
        }

        @Override
        public Builder setFollowRedirects(boolean followRedirects) {
            this.requestBuilder.setFollowRedirects(followRedirects);
            return this;
        }

        public Builder setMaximumConnectionsTotal(int defaultMaxTotalConnections) {
            this.configBuilder.setMaximumConnectionsTotal(defaultMaxTotalConnections);
            return this;
        }

        public Builder setMaximumConnectionsPerHost(int defaultMaxConnectionPerHost) {
            this.configBuilder.setMaximumConnectionsPerHost(defaultMaxConnectionPerHost);
            return this;
        }

        public Builder setConnectionTimeoutInMs(int connectionTimeuot) {
            this.configBuilder.setConnectionTimeoutInMs(connectionTimeuot);
            return this;
        }

        public Builder setIdleConnectionInPoolTimeoutInMs(int defaultIdleConnectionInPoolTimeoutInMs) {
            this.configBuilder.setIdleConnectionInPoolTimeoutInMs(defaultIdleConnectionInPoolTimeoutInMs);
            return this;
        }

        public Builder setRequestTimeoutInMs(int defaultRequestTimeoutInMs) {
            this.configBuilder.setRequestTimeoutInMs(defaultRequestTimeoutInMs);
            return this;
        }

        public Builder setMaximumNumberOfRedirects(int maxDefaultRedirects) {
            this.configBuilder.setMaximumNumberOfRedirects(maxDefaultRedirects);
            return this;
        }

        public Builder setCompressionEnabled(boolean compressionEnabled) {
            this.configBuilder.setCompressionEnabled(compressionEnabled);
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.configBuilder.setUserAgent(userAgent);
            return this;
        }

        public Builder setAllowPoolingConnection(boolean allowPoolingConnection) {
            this.configBuilder.setAllowPoolingConnection(allowPoolingConnection);
            return this;
        }

        public Builder setScheduledExecutorService(ScheduledExecutorService reaper) {
            this.configBuilder.setScheduledExecutorService(reaper);
            return this;
        }

        public Builder setExecutorService(ExecutorService applicationThreadPool) {
            this.configBuilder.setExecutorService(applicationThreadPool);
            return this;
        }

        public Builder setSSLEngineFactory(SSLEngineFactory sslEngineFactory) {
            this.configBuilder.setSSLEngineFactory(sslEngineFactory);
            return this;
        }

        public Builder setSSLContext(SSLContext sslContext) {
            this.configBuilder.setSSLContext(sslContext);
            return this;
        }

        public Builder setRequestCompressionLevel(int requestCompressionLevel) {
            this.configBuilder.setRequestCompressionLevel(requestCompressionLevel);
            return this;
        }

        public Builder setRealmDomain(String domain) {
            this.realm().setDomain(domain);
            return this;
        }

        public Builder setRealmPrincipal(String principal) {
            this.realm().setPrincipal(principal);
            return this;
        }

        public Builder setRealmPassword(String password) {
            this.realm().setPassword(password);
            return this;
        }

        public Builder setRealmScheme(Realm.AuthScheme scheme) {
            this.realm().setScheme(scheme);
            return this;
        }

        public Builder setRealmName(String realmName) {
            this.realm().setRealmName(realmName);
            return this;
        }

        public Builder setRealmUsePreemptiveAuth(boolean usePreemptiveAuth) {
            this.realm().setUsePreemptiveAuth(usePreemptiveAuth);
            return this;
        }

        public Builder setRealmEnconding(String enc) {
            this.realm().setEnconding(enc);
            return this;
        }

        public Builder setProxyProtocol(ProxyServer.Protocol protocol) {
            this.proxyProtocol = protocol;
            return this;
        }

        public Builder setProxyHost(String host) {
            this.proxyHost = host;
            return this;
        }

        public Builder setProxyPrincipal(String principal) {
            this.proxyPrincipal = principal;
            return this;
        }

        public Builder setProxyPassword(String password) {
            this.proxyPassword = password;
            return this;
        }

        public Builder setProxyPort(int port) {
            this.proxyPort = port;
            return this;
        }

        public Builder setDefaultThrowableHandler(ThrowableHandler throwableHandler) {
            this.defaultThrowableHandler = throwableHandler;
            return this;
        }

        public Builder setErrorDocumentBehaviour(ErrorDocumentBehaviour behaviour) {
            this.errorDocumentBehaviour = behaviour;
            return this;
        }

        @Override
        public Builder setResumableDownload(boolean enableResumableDownload) {
            this.enableResumableDownload = enableResumableDownload;
            return this;
        }

        private Realm.RealmBuilder realm() {
            if (this.realmBuilder == null) {
                this.realmBuilder = new Realm.RealmBuilder();
            }
            return this.realmBuilder;
        }

        public Builder setListener(SimpleAHCTransferListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder setMaxRequestRetry(int maxRequestRetry) {
            this.configBuilder.setMaxRequestRetry(maxRequestRetry);
            return this;
        }

        @Override
        public SimpleAsyncHttpClient build() {
            if (this.realmBuilder != null) {
                this.configBuilder.setRealm(this.realmBuilder.build());
            }
            if (this.proxyHost != null) {
                this.configBuilder.setProxyServer(new ProxyServer(this.proxyProtocol, this.proxyHost, this.proxyPort, this.proxyPrincipal, this.proxyPassword));
            }
            this.configBuilder.addIOExceptionFilter(new ResumableIOExceptionFilter());
            SimpleAsyncHttpClient sc = new SimpleAsyncHttpClient(this.configBuilder.build(), this.requestBuilder, this.defaultThrowableHandler, this.errorDocumentBehaviour, this.enableResumableDownload, this.ahc, this.listener);
            return sc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DerivedBuilder {
        public DerivedBuilder setFollowRedirects(boolean var1);

        public DerivedBuilder setVirtualHost(String var1);

        public DerivedBuilder setUrl(String var1);

        public DerivedBuilder setParameters(FluentStringsMap var1) throws IllegalArgumentException;

        public DerivedBuilder setParameters(Map<String, Collection<String>> var1) throws IllegalArgumentException;

        public DerivedBuilder setHeaders(Map<String, Collection<String>> var1);

        public DerivedBuilder setHeaders(FluentCaseInsensitiveStringsMap var1);

        public DerivedBuilder setHeader(String var1, String var2);

        public DerivedBuilder addQueryParameter(String var1, String var2);

        public DerivedBuilder addParameter(String var1, String var2) throws IllegalArgumentException;

        public DerivedBuilder addHeader(String var1, String var2);

        public DerivedBuilder addCookie(Cookie var1);

        public DerivedBuilder addBodyPart(Part var1) throws IllegalArgumentException;

        public DerivedBuilder setResumableDownload(boolean var1);

        public SimpleAsyncHttpClient build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorDocumentBehaviour {
        WRITE,
        ACCUMULATE,
        OMIT;

    }
}

