/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.gtuploader;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.FileConverter;
import com.terradue.gtuploader.GeoTIFFUploader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    @Parameter(names={"-h", "--help"}, description="Display help information.")
    private boolean printHelp;
    @Parameter(names={"-v", "--version"}, description="Display version information.")
    private boolean printVersion;
    @Parameter(names={"-d", "--domain"}, description="The REST Geoserver host domain.")
    private String restServerHost;
    @Parameter(names={"-p", "--port"}, description="The REST Geoserver host port.")
    private int restServerPort = 80;
    @Parameter(names={"-t", "--timeout"}, description="The REST request timeout (in seconds).")
    private int requestTimeout = 5;
    @Parameter(names={"-b", "--basepath"}, description="The REST Geoserver base path.")
    private String restBasePath = "geoserver";
    @Parameter(names={"-u", "--user"}, description="The REST Geoserver credentials [ use the expression ${username}(:${password}) ].")
    private String credentials;
    @Parameter(names={"-f", "--file"}, description="The file has to be converted and uploaded.", converter=FileConverter.class)
    private File toBeConverted;
    @Parameter(names={"-X", "--debug"}, description="Produce execution debug output.")
    private boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(String ... args) {
        Throwable error;
        int exit;
        long start;
        Logger logger;
        block39: {
            String restServerUsername;
            JCommander jCommander = new JCommander((Object)this);
            jCommander.setProgramName(System.getProperty("app.name"));
            jCommander.parseWithoutValidation(args);
            if (this.printHelp) {
                jCommander.usage();
                System.exit(-1);
            }
            if (this.printVersion) {
                Properties properties = new Properties();
                InputStream input = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/com.terradue/geotiff-uploader/pom.properties");
                if (input != null) {
                    try {
                        properties.load(input);
                    }
                    catch (IOException e) {
                    }
                    finally {
                        try {
                            input.close();
                        }
                        catch (IOException e) {}
                    }
                }
                System.out.printf("Terradue GeoTIFF Uploader %s (%s)%n", properties.getProperty("version"), properties.getProperty("build"));
                System.out.printf("Java version: %s, vendor: %s%n", System.getProperty("java.version"), System.getProperty("java.vendor"));
                System.out.printf("Java home: %s%n", System.getProperty("java.home"));
                System.out.printf("Default locale: %s_%s, platform encoding: %s%n", System.getProperty("user.language"), System.getProperty("user.country"), System.getProperty("sun.jnu.encoding"));
                System.out.printf("OS name: \"%s\", version: \"%s\", arch: \"%s\", family: \"%s\"%n", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), Main.getOsFamily());
                System.exit(-1);
            }
            if (this.toBeConverted == null) {
                System.out.println("No geo data file specified.");
                System.exit(-1);
            }
            if (!this.toBeConverted.exists() || this.toBeConverted.isDirectory()) {
                System.out.printf("Non-readable geo data file: %s (No such file).%n", this.toBeConverted);
                System.exit(-1);
            }
            if (this.restServerHost == null) {
                System.out.println("No REST Geoserver host domain has been specified.");
                System.exit(-1);
            }
            if (this.credentials == null) {
                System.out.println("No REST Geoserver credential has been specified for this conversion.");
                System.exit(-1);
            }
            System.out.println(" _______ ___     _____         _______ _____ ______ ______   _    _       _                 _");
            System.out.println("|__   __|__ \\   / ____|       |__   __|_   _|  ____|  ____| | |  | |     | |               | |");
            System.out.println("   | |     ) | | |  __  ___  ___ | |    | | | |__  | |__    | |  | |_ __ | | ___   __ _  __| | ___ _ __ ");
            System.out.println("   | |    / /  | | |_ |/ _ \\/ _ \\| |    | | |  __| |  __|   | |  | | '_ \\| |/ _ \\ / _` |/ _` |/ _ \\ '__|");
            System.out.println("   | |   / /_  | |__| |  __/ (_) | |   _| |_| |    | |      | |__| | |_) | | (_) | (_| | (_| |  __/ |   ");
            System.out.println("   |_|  |____|  \\_____|\\___|\\___/|_|  |_____|_|    |_|       \\____/| .__/|_|\\___/ \\__,_|\\__,_|\\___|_|");
            System.out.println("                                                                   | |                                  ");
            System.out.println("                                                                   |_|");
            logger = LoggerFactory.getLogger(this.getClass());
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext((Context)lc);
                lc.reset();
                configurator.doConfigure(this.getClass().getClassLoader().getResourceAsStream("logback-config.xml"));
            }
            catch (JoranException je) {
                // empty catch block
            }
            logger.info("");
            logger.info("------------------------------------------------------------------------");
            logger.info("Terradue GeoTIFF Uploader - converting and uploading '{}' to '{}'", (Object)this.toBeConverted, (Object)this.restServerHost);
            logger.info("------------------------------------------------------------------------");
            logger.info("");
            start = System.currentTimeMillis();
            exit = 0;
            String restServerPassword = "";
            int credentialsSeparator = this.credentials.indexOf(58);
            if (credentialsSeparator > 0) {
                restServerUsername = this.credentials.substring(0, credentialsSeparator);
                restServerPassword = this.credentials.substring(credentialsSeparator + 1);
            } else {
                restServerUsername = this.credentials;
            }
            error = null;
            GeoTIFFUploader uploader = null;
            try {
                try {
                    uploader = new GeoTIFFUploader.Builder().setRestServerHost(this.restServerHost).setRestServerPort(this.restServerPort).setRequestTimeout(this.requestTimeout).setRestBasePath(this.restBasePath).setRestServerUsername(restServerUsername).setRestServerPassword(restServerPassword).newGeoTIFFUploader();
                    uploader.convertAndUpload(this.toBeConverted);
                }
                catch (Throwable t) {
                    exit = -1;
                    error = t;
                    Object var15_20 = null;
                    if (uploader != null) {
                        uploader.close();
                    }
                    logger.info("");
                    logger.info("------------------------------------------------------------------------");
                    logger.info("Terradue GeoTIFF Uploader {}", (Object)(exit < 0 ? "FAILURE" : "SUCCESS"));
                    if (exit < 0) {
                        logger.info("");
                        if (this.debug) {
                            logger.error("GeoTIFF Uploader terminated with errors", error);
                        } else {
                            logger.error("GeoTIFF Uploader terminated with errors: {}", (Object)error.getMessage());
                        }
                        logger.info("");
                    }
                    logger.info("Total time: {}s", (Object)((System.currentTimeMillis() - start) / 1000L));
                    logger.info("Finished at: {}", (Object)new Date());
                    Runtime runtime = Runtime.getRuntime();
                    int megaUnit = 0x100000;
                    logger.info("Final Memory: {}M/{}M", (Object)((runtime.totalMemory() - runtime.freeMemory()) / 0x100000L), (Object)(runtime.totalMemory() / 0x100000L));
                    logger.info("------------------------------------------------------------------------");
                    System.exit(exit);
                    return;
                }
                Object var15_19 = null;
                if (uploader == null) break block39;
                uploader.close();
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                if (uploader != null) {
                    uploader.close();
                }
                logger.info("");
                logger.info("------------------------------------------------------------------------");
                logger.info("Terradue GeoTIFF Uploader {}", (Object)(exit < 0 ? "FAILURE" : "SUCCESS"));
                if (exit < 0) {
                    logger.info("");
                    if (this.debug) {
                        logger.error("GeoTIFF Uploader terminated with errors", error);
                    } else {
                        logger.error("GeoTIFF Uploader terminated with errors: {}", (Object)error.getMessage());
                    }
                    logger.info("");
                }
                logger.info("Total time: {}s", (Object)((System.currentTimeMillis() - start) / 1000L));
                logger.info("Finished at: {}", (Object)new Date());
                Runtime runtime = Runtime.getRuntime();
                int megaUnit = 0x100000;
                logger.info("Final Memory: {}M/{}M", (Object)((runtime.totalMemory() - runtime.freeMemory()) / 0x100000L), (Object)(runtime.totalMemory() / 0x100000L));
                logger.info("------------------------------------------------------------------------");
                System.exit(exit);
                throw throwable;
            }
        }
        logger.info("");
        logger.info("------------------------------------------------------------------------");
        logger.info("Terradue GeoTIFF Uploader {}", (Object)(exit < 0 ? "FAILURE" : "SUCCESS"));
        if (exit < 0) {
            logger.info("");
            if (this.debug) {
                logger.error("GeoTIFF Uploader terminated with errors", error);
            } else {
                logger.error("GeoTIFF Uploader terminated with errors: {}", (Object)error.getMessage());
            }
            logger.info("");
        }
        logger.info("Total time: {}s", (Object)((System.currentTimeMillis() - start) / 1000L));
        logger.info("Finished at: {}", (Object)new Date());
        Runtime runtime = Runtime.getRuntime();
        int megaUnit = 0x100000;
        logger.info("Final Memory: {}M/{}M", (Object)((runtime.totalMemory() - runtime.freeMemory()) / 0x100000L), (Object)(runtime.totalMemory() / 0x100000L));
        logger.info("------------------------------------------------------------------------");
        System.exit(exit);
    }

    private Main() {
    }

    public static void main(String[] args) {
        new Main().execute(args);
    }

    private static final String getOsFamily() {
        String osName = System.getProperty("os.name").toLowerCase();
        String pathSep = System.getProperty("path.separator");
        if (osName.indexOf("windows") != -1) {
            return "windows";
        }
        if (osName.indexOf("os/2") != -1) {
            return "os/2";
        }
        if (osName.indexOf("z/os") != -1 || osName.indexOf("os/390") != -1) {
            return "z/os";
        }
        if (osName.indexOf("os/400") != -1) {
            return "os/400";
        }
        if (pathSep.equals(";")) {
            return "dos";
        }
        if (osName.indexOf("mac") != -1) {
            if (osName.endsWith("x")) {
                return "mac";
            }
            return "unix";
        }
        if (osName.indexOf("nonstop_kernel") != -1) {
            return "tandem";
        }
        if (osName.indexOf("openvms") != -1) {
            return "openvms";
        }
        if (pathSep.equals(":")) {
            return "unix";
        }
        return "undefined";
    }
}

