/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketByteListener;
import com.ning.http.client.websocket.WebSocketListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;

public class NettyWebSocket
implements WebSocket {
    private final Channel channel;
    private final ConcurrentLinkedQueue<WebSocketListener> listeners = new ConcurrentLinkedQueue();

    public NettyWebSocket(Channel channel) {
        this.channel = channel;
    }

    public WebSocket sendMessage(byte[] message) {
        this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])message)));
        return this;
    }

    public WebSocket stream(byte[] fragment, boolean last) {
        throw new UnsupportedOperationException("Streaming currently only supported by the Grizzly provider.");
    }

    public WebSocket stream(byte[] fragment, int offset, int len, boolean last) {
        throw new UnsupportedOperationException("Streaming currently only supported by the Grizzly provider.");
    }

    public WebSocket sendTextMessage(String message) {
        this.channel.write((Object)new TextWebSocketFrame(message));
        return this;
    }

    public WebSocket streamText(String fragment, boolean last) {
        throw new UnsupportedOperationException("Streaming currently only supported by the Grizzly provider.");
    }

    public WebSocket sendPing(byte[] payload) {
        this.channel.write((Object)new PingWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    public WebSocket sendPong(byte[] payload) {
        this.channel.write((Object)new PongWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    public WebSocket addWebSocketListener(WebSocketListener l) {
        this.listeners.add(l);
        return this;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() {
        this.onClose();
        this.channel.close();
    }

    protected void onMessage(byte[] message) {
        for (WebSocketListener l : this.listeners) {
            if (!WebSocketByteListener.class.isAssignableFrom(l.getClass())) continue;
            ((WebSocketByteListener)WebSocketByteListener.class.cast(l)).onMessage(message);
        }
    }

    protected void onTextMessage(String message) {
        for (WebSocketListener l : this.listeners) {
            if (!WebSocketTextListener.class.isAssignableFrom(l.getClass())) continue;
            ((WebSocketTextListener)WebSocketTextListener.class.cast(l)).onMessage(message);
        }
    }

    protected void onError(Throwable t) {
        for (WebSocketListener l : this.listeners) {
            l.onError(t);
        }
    }

    protected void onClose() {
        for (WebSocketListener l : this.listeners) {
            l.onClose(this);
        }
    }

    public String toString() {
        return "NettyWebSocket{channel=" + this.channel + '}';
    }
}

