#!/bin/env bash

# Project:       GeoTIFF Uploader
# Author:        $Author: stripodi $ (Terradue Srl)
# Last update:   $Date: 2011-09-02 11:20:38 +0200 (Fri, 02 Sep 2011) $
# Element:       ify web portal
# Context:       services/gtu
# Name:          service.js
# Version:       1.0.1-4.5.0-126580 (UNKNOWN_BRANCH@r??????; 2017-06-09 23:59:06+0000)
# Description:   Service descriptor for gtu. 
#
# This document is the property of Terradue and contains information directly
# resulting from knowledge and experience of Terradue.
# Any changes to this code is forbidden without written consent from Terradue Srl
#
# Contact: info@terradue.com

. params
 
failCount=0

while read url
do
    file=`basename $url`
    ify_notify_param_start "$file"
    ify_notify_action "secp"
    echo "$url" | secp -o "$EOGRID_TMP" -
    res=$?
    if [ "$res" != "0" ]
    then
        logApp "ERROR" "Could not retrieve $url"
        exit $res
    fi

    if [ "$debug" = "true" ]
    then
        $debugArg = " -X"
    fi

    logExec "$DIR/bin/gtu -d $domain -p $port -b $basepath -u $user -f $EOGRID_TMP/$file -t $timeout $debugArg"
    res=$?
    if [ "$res" != "0" ]
    then
        failCount=$((failCount+1))
    fi

    LOG_DIR=$EOGRID_LOG/$file
    mkdir -p $LOG_DIR
    mv $DIR/logs/* $LOG_DIR

    ify_notify_param_stop "$file"
done

if [ $failCount -ne 0 ]
then
    logApp "ERROR" "$failCount products not processed"
    exit 1
fi
