package org.gcube.data.analysis.statisticalmanager.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

import org.apache.commons.io.IOUtils;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import com.thoughtworks.xstream.XStream;

public class RemoteStorage {

	private static GCUBELog logger = new GCUBELog(RemoteStorage.class);
	private IClient storage;
	
	public RemoteStorage(String userLogin, String scope) throws Exception {
	
		this.storage = new StorageClient(ServiceContext.class.getPackage().getName(),
				ServiceContext.SERVICE_NAME, userLogin , AccessType.SHARED,
				GCUBEScope.getScope(scope)).getClient();
		
	}
	
	public String putFile(File file, String fileName) {
		
		String rfileName = File.separator + fileName;
		storage.put(true).LFile(file.getAbsolutePath()).RFile(rfileName);
		return storage.getUrl().RFile(rfileName);
	}

	public void putStream(InputStream is, String path) {
		storage.put(true).LFile(is).RFile(path);
	}
	
	public String putObject(Object outputs) throws IOException {
	
		File file = File.createTempFile("output", "sm");
		FileOutputStream fos = null;
		try{
			fos = new FileOutputStream (file);
			XStream xstream = new XStream();
			xstream.toXML(outputs, fos);
		} finally {
			IOUtils.closeQuietly(fos);
		}
		logger.debug("Create tmp file " + file.getAbsolutePath());
		return putFile(file, UUID.randomUUID().toString());
	}
	
	public File getFile(String path) throws IOException {
		
		InputStream is = storage.get().RFileAStream(path);
		
		OutputStream out = null;
		try {
			// write the inputStream to a FileOutputStream
			File file = File.createTempFile("file", "sm");
			out = new FileOutputStream(file);

			int read = 0;
			byte[] bytes = new byte[1024];

			while ((read = is.read(bytes)) != -1) {
				out.write(bytes, 0, read);
			}
			return file;
		
		} finally {
			if(is!= null)is.close();
			if(out!= null) {
				out.flush();
				out.close();
			}
		}
	}
	
}
