package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;

public class CSVLineProcessorGeneric extends CSVAbstractLineProcessor {

		private boolean stop = true;
		private int count = 0;
		private Map<String,List<String>> map; 
		
		public CSVLineProcessorGeneric(String separator) {
			super(separator);
		}
		
		@Override
		public boolean continueProcessing() {
			return stop;
		}

		@Override
		public void processDataLine(int arg0, List<String> fields) {
			super.processDataLine(arg0, fields);
			
			for ( final String fieldValue : fields ) {
				if (fieldValue != null) {
					for(String value : fieldValue.split(separator)) {
						
						String sqlType = getSqlType(value);

						sqlTypes.add(sqlType);
					}
					
				} else {
					sqlTypes.add("varchar");
				}
			}
			stop = false;
		}

		private String getSqlType(String value) {
			ArrayList<String> values = new ArrayList<String>();
			values.add(value);
			
			String className = DataTypeRecognizer.guessType(values);
			String sqlType = null;
			if (String.class.getName().equals(className)) {
				sqlType = "varchar";
			}						
			if(Boolean.class.getName().equals(className)) {
				sqlType = "boolean";
			}		

			if(BigDecimal.class.getName().equals(className)) {
				sqlType = "double precision";
			}
			return sqlType;
		}
		

			   
};
	
