package org.gcube.data.analysis.statisticalmanager.persistence;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;



public class RuntimeResourceManager {
	
	private static GCUBELog logger = new GCUBELog(RuntimeResourceManager.class);

	private static final String RUNTIME_RESOURCE_DB = "StatisticalManagerDataBase";
	
	public static void initializeDataBase() throws Exception {
		
		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBERuntimeResourceQuery rtrQuery = client.getQuery(GCUBERuntimeResourceQuery.class);
		rtrQuery.addAtomicConditions(new AtomicCondition("/Profile/Name",RUNTIME_RESOURCE_DB));
		
		Map<String, GCUBEScope> scopes = ServiceContext.getContext().getInstance().getScopes();
		List<GCUBERuntimeResource> rtrs = null;
		for(Entry<String, GCUBEScope> scope : scopes.entrySet()) {
			rtrs = client.execute(rtrQuery,scope.getValue());
			if (rtrs != null && !rtrs.isEmpty())
				break;
			else {
				logger.debug(" Runtime resource NOT FOUND in scope  " + scope.getValue());
			}
		}
		
		if(rtrs == null || rtrs.isEmpty())
			throw new StatisticalManagerException("Runtime resource " + RUNTIME_RESOURCE_DB + " not found");
		
		GCUBERuntimeResource rtr = rtrs.get(0);
		if (rtr.getAccessPoints() == null ||  rtr.getAccessPoints().isEmpty()) 
			throw new StatisticalManagerException("Accesspoint in resource " + RUNTIME_RESOURCE_DB + " not found");

		for (AccessPoint ap : rtr.getAccessPoints()) {
			
			if (ap.getEntryname().equals("jdbc")) {
				
				logger.debug("URL jdbc  " + ap.getEndpoint());
				logger.debug("User jdbc " + ap.getUsername());
				logger.debug("Pass jdbc " + ap.getPassword());
				
				DataBaseManager.initializeDataSource(ap.getEndpoint(),
						ap.getUsername(), ap.getPassword());
			}
			
			if (ap.getEntryname().equals("hibernate")) {
				logger.debug("URL hibernate  " + ap.getEndpoint());
				logger.debug("User hibernate " + ap.getUsername());
				logger.debug("Pass hibernate " + ap.getPassword());
				
				HibernateManager.buildSessionFactory(ap.getEndpoint(),
						ap.getUsername(), ap.getPassword());
				
			}
		}
	}

	public static List<AccessPoint> getRRAccessPoint(String runtimeResource) throws Exception{

		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBERuntimeResourceQuery rtrQuery = client.getQuery(GCUBERuntimeResourceQuery.class);
		rtrQuery.addAtomicConditions(new AtomicCondition("/Profile/Name", runtimeResource));
		
		Map<String, GCUBEScope> scopes = ServiceContext.getContext().getInstance().getScopes();
		List<GCUBERuntimeResource> rtrs = null;
		for(Entry<String, GCUBEScope> scope : scopes.entrySet()) {
			rtrs = client.execute(rtrQuery,scope.getValue());
			if (rtrs != null && !rtrs.isEmpty())
				break;
			else {
				logger.debug(" Runtime resource " + runtimeResource + " NOT FOUND in scope  " + scope.getValue());
			}
		}
		
		if(rtrs == null || rtrs.isEmpty())
			throw new StatisticalManagerException("Runtime resource " + RUNTIME_RESOURCE_DB + " not found");
		
		GCUBERuntimeResource rtr = rtrs.get(0);
		if (rtr.getAccessPoints() == null ||  rtr.getAccessPoints().isEmpty()) 
			throw new StatisticalManagerException("Accesspoint in resource " + RUNTIME_RESOURCE_DB + " not found");

		return rtr.getAccessPoints();
	}


}
