/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.sql.Connection;
import java.sql.Date;
import java.sql.Statement;
import java.util.UUID;
import javax.sql.DataSource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.streams.Stream;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;

public class OccurrenceStreamConverter {
    private DataSource dataSource;
    private Stream<OccurrencePoint> stream;
    private String tableName;
    private static GCUBELog logger = new GCUBELog(OccurrenceStreamConverter.class);

    public String getTableName() {
        return this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable() throws Exception {
        Connection conn = this.dataSource.getConnection();
        Statement stmt = conn.createStatement();
        String dbTableName = TableTemplates.OCCURRENCE_SPECIES.toString() + "_ID_" + UUID.randomUUID().toString().replace("-", "_");
        dbTableName = dbTableName.toLowerCase();
        String sql = "CREATE TABLE " + dbTableName + "(institutionCode VARCHAR," + "collectionCode VARCHAR," + "dataSet VARCHAR," + "catalogueNumber VARCHAR," + "dataProvider VARCHAR," + "dataSource VARCHAR," + "author VARCHAR," + "credits VARCHAR," + "recordedBy VARCHAR," + "eventDate TIMESTAMP," + "modified TIMESTAMP," + "scientificName VARCHAR," + "kingdom VARCHAR," + "family VARCHAR," + "locality VARCHAR," + "country VARCHAR," + "citation VARCHAR," + "decimalLatitude double precision," + "decimalLongitude double precision," + "coordinateUncertaintyInMeters VARCHAR," + "maxDepth double precision," + "minDepth double precision," + "basisOfRecord VARCHAR)";
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        this.tableName = dbTableName;
    }

    public OccurrenceStreamConverter(DataSource dataSource, Stream<OccurrencePoint> stream) throws Exception {
        this.stream = stream;
        this.dataSource = dataSource;
        this.createTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.dataSource.getConnection();
            String sql = "insert into " + this.tableName + "(institutionCode, " + "collectionCode, " + "dataSet, " + "catalogueNumber, " + "dataProvider, " + "dataSource, " + "author," + "credits," + "recordedBy, " + "eventDate, " + "modified, " + "scientificName, " + "kingdom, " + "family, " + "locality, " + "country, " + "citation, " + "decimalLatitude, " + "decimalLongitude, " + "coordinateUncertaintyInMeters, " + "maxDepth, " + "minDepth, " + "basisOfRecord) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)";
            pstmt = conn.prepareStatement(sql);
            while (this.stream.hasNext()) {
                logger.debug((Object)"----- Stream has element");
                OccurrencePoint occurrence = (OccurrencePoint)this.stream.next();
                logger.debug((Object)("Occurrence " + occurrence));
                pstmt.setString(1, occurrence.getInstitutionCode());
                pstmt.setString(2, occurrence.getCollectionCode());
                if (occurrence.getDataSet() != null) {
                    pstmt.setString(3, occurrence.getDataSet().getName());
                    if (occurrence.getDataSet().getDataProvider() != null) {
                        pstmt.setString(5, occurrence.getDataSet().getDataProvider().getName());
                    } else {
                        pstmt.setString(5, null);
                    }
                } else {
                    pstmt.setString(3, null);
                    pstmt.setString(5, null);
                }
                pstmt.setString(4, occurrence.getCatalogueNumber());
                pstmt.setString(6, occurrence.getProvider());
                pstmt.setString(7, occurrence.getAuthor());
                pstmt.setString(8, occurrence.getCredits());
                pstmt.setString(9, occurrence.getRecordedBy());
                if (occurrence.getEventDate() != null) {
                    pstmt.setDate(10, new Date(occurrence.getEventDate().getTime().getTime()));
                } else {
                    pstmt.setDate(10, null);
                }
                if (occurrence.getModified() != null) {
                    pstmt.setDate(11, new Date(occurrence.getModified().getTime().getTime()));
                } else {
                    pstmt.setDate(11, null);
                }
                pstmt.setString(12, occurrence.getScientificName());
                pstmt.setString(13, occurrence.getKingdom());
                pstmt.setString(14, occurrence.getFamily());
                pstmt.setString(15, occurrence.getLocality());
                pstmt.setString(16, occurrence.getCountry());
                pstmt.setString(17, occurrence.getCitation());
                pstmt.setDouble(18, occurrence.getDecimalLatitude());
                pstmt.setDouble(19, occurrence.getDecimalLongitude());
                pstmt.setString(20, occurrence.getCoordinateUncertaintyInMeters());
                pstmt.setDouble(21, occurrence.getMaxDepth());
                pstmt.setDouble(22, occurrence.getMinDepth());
                if (occurrence.getBasisOfRecord() != null) {
                    pstmt.setString(23, occurrence.getBasisOfRecord().toString());
                } else {
                    pstmt.setString(23, null);
                }
                pstmt.executeUpdate();
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

